<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\core\Schemes;

class Turio_Blog_Widget_Two extends Widget_Base {

	public function get_name() {
		return 'blog_two';
	}

	public function get_title() {
		return esc_html__( 'TX Blog Style Two', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
	
		$this->start_controls_section(
			'post_settings',
			[
				'label' => esc_html__( 'Post Settings', 'turio-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
		$this->add_control(
			'turio_blog_two_category_switcher',
			[
				'label' => esc_html__('Show Category', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'turio-core'),
				'label_off' => esc_html__('Hide', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_blog_two_icon_switcher',
			[
				'label' => esc_html__('Show Icon', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'turio-core'),
				'label_off' => esc_html__('Hide', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'blog_posts_per_page',
			[
				'label'       => esc_html__( 'Posts Per Page', 'turio-core' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 3,
				'label_block' => true,
			]
		);
		$this->add_control(
			'blog_orderby',
			[
				'label'   => esc_html__( 'Order By', 'turio-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'post_date',
				'options' => [
					'ID'         => esc_html__( 'Post Id', 'turio-core' ),
					'author'     => esc_html__( 'Post Author', 'turio-core' ),
					'title'      => esc_html__( 'Title', 'turio-core' ),
					'post_date'       => esc_html__( 'Date', 'turio-core' ),
					'rand'       => esc_html__( 'Random', 'turio-core' ),
					'menu_order' => esc_html__( 'Menu Order', 'turio-core' ),
				],
			]
		);
		$this->add_control(
			'blog_order',
			[
				'label'   => esc_html__( 'Order', 'turio-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__( 'Ascending', 'turio-core' ),
					'desc' => esc_html__( 'Descending', 'turio-core' )
				],
				'default' => 'desc',
			]
		);

		$this->end_controls_section();

        /// Date Style
        $this->start_controls_section(
			'blog_date_style',
			[
				'label' => esc_html__( 'Category Style', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_two_category_switcher' => 'yes'
				]

			]
		);

        $this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    => esc_html__( 'Typography', 'turio-core' ),
				'name'     => 'blog_date_typography',
				'selector' => '{{WRAPPER}} .blog-card-gamma .blog-thumb .blog-lavel a',

			]
		);

		$this->add_control(
			'blog_date_color',
			[
				'label'     => esc_html__( 'Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma .blog-thumb .blog-lavel a' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'blog_date_bg_color',
			[
				'label'     => esc_html__( 'Background', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma .blog-thumb .blog-lavel a' => 'background: {{VALUE}};',
				],
			
			]
		);

        $this->add_control(
			'blog_date_bg_hover_color',
			[
				'label'     => esc_html__( 'Background Hover', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma:hover .blog-thumb .blog-lavel a' => 'background: {{VALUE}};',
				],
			
			]
		);

		$this->end_controls_section();

        /// Blog Title Style
		$this->start_controls_section(
			'blog_title_style',
			[
				'label' => esc_html__( 'Title', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
	
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    => esc_html__( 'Typography', 'turio-core' ),
				'name'     => 'blog_title_typography',
				'selector' => '{{WRAPPER}} .blog-card-gamma .blog-content .blog-title a',

			]
		);

		$this->add_control(
			'blog_title_color',
			[
				'label'     => esc_html__( 'Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma .blog-content .blog-title a' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);

		$this->end_controls_section();

        // Blog Author Style
		$this->start_controls_section(
			'blog_info_style',
			[
				'label' => esc_html__( 'Info Style', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
	
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    => esc_html__( 'Typography', 'turio-core' ),
				'name'     => 'blog_info_typography',
				'selector' => '{{WRAPPER}} .blog-card-gamma .blog-content .blog-body-top a',

			]
		);

		$this->add_control(
			'blog_info_color',
			[
				'label'     => esc_html__( 'Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma .blog-content .blog-body-top a' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);

		$this->end_controls_section();

        /// Icon Style
		$this->start_controls_section(
			'blog_icon_style',
			[
				'label' => esc_html__( 'Icon', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_two_icon_switcher' => 'yes'
				]

			]
		);

		$this->add_control(
			'blog_icon_color',
			[
				'label'     => esc_html__( 'Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-gamma .blog-content .blog-body-top a i' => 'color: {{VALUE}}',
				],
				'default' => '#54A15D',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

        $query = new \WP_Query(
            array(
                'post_type'      => 'post',
                'posts_per_page' => $settings['blog_posts_per_page'],
                'orderby'        => $settings['blog_orderby'],
                'order'          => $settings['blog_order'],
				'paged' 		 => (get_query_var('paged')) ? get_query_var('paged') : 1,
                'offset'         => 0,
                'post_status'    => 'publish'
            )
        );
       

	?>

<div class="blog-area blog-style-two">
        <div class="container">
            <div class="row g-4">
            <?php
				if(!empty($query->have_posts())) :
					$num = 0;
					while ( $query->have_posts() ) :
					$num++;
					$query->the_post();
                ?>

                <div class="col-lg-4 col-md-6">
                    <div class="blog-card-gamma wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
                        <div class="blog-thumb">
                                <?php if ( has_post_thumbnail() ) { ?>
									<a href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail(); ?>
									</a>
								<?php }?>

                            <div class="blog-lavel">
                                <?php 
                                    $categories = get_the_category();
									if ('yes' == $settings['turio_blog_two_category_switcher'] && ! empty( $categories )) {
									  
                                        echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">'. esc_html( $categories[0]->name ) .'</a>';

									}
                                    
                                ?>
                            </div>
                        </div>
                        <div class="blog-content">
                            <div class="blog-body-top">
                                <a href="#" class="blog-writer"><?php if ('yes' == $settings['turio_blog_two_icon_switcher']) { echo '<i class="bi bi-person-circle"></i>';} ?> <?php _e('By ','turio-core'); ?> <?php echo get_the_author();?> </a>
                                <a href="<?php echo get_day_link( get_post_time( 'Y' ), get_post_time( 'm' ), get_post_time( 'j' ) ); ?>" class="blog-comments"><?php if ('yes' == $settings['turio_blog_two_icon_switcher']) { echo '<i class="bi bi-calendar3"></i>';} ?> <?php echo get_the_date();?></a>
                            </div>
                            <h4 class="blog-title"><a href="<?php the_permalink(); ?>">
							<?php echo esc_html__( substr( get_the_title(),'0','55' ),'turio-core' ); ?>
						</a></h4>
                        </div>
                    </div>
                </div>

                <?php
                    endwhile; 
                    wp_reset_query();
                endif;
                ?>


            </div>
        </div>
    </div>
		<?php
	}

}

Plugin::instance()->widgets_manager->register( new Turio_Blog_Widget_Two() );
