<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioButtonWidget extends Widget_Base {

	public function get_name() {
		return 'turio_button';
	}

	public function get_title() {
		return esc_html__( 'TX Button', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-button';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
        // Start Button Widget Content
		$this->start_controls_section(
			'section_button',
			[
				'label' 		 => esc_html__('General','turio-core'),
				'tab'   		 => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_button_widget_text',
			[
				'label'       	 => esc_html__('Button Text', 'turio-core'),
				'type'       	 => Controls_Manager::TEXT,
				'default'     	 => esc_html__('Button', 'turio-core'),
				'label_block' 	 => true,
			]
		);
		$this->add_control(
			'turio_button_widget_url',
			[
				'label'          => esc_html__('Button URL', 'turio-core'),
				'type'           => Controls_Manager::URL,
				'placeholder'    => esc_html__('http://your-link.com', 'turio-core'),
				'show_external'  => true,
				'default'        => [
					'url'        => '#',
					'is_external'=> true,
					'nofollow'   => true,
				]
			]
		);
        $this->add_responsive_control(
			'turio_button_widget_align',
			[
				'label' 		=> __( 'Alignment', 'turio-core' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => __( 'Left', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => __( 'Center', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => __( 'Right', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => __( 'Justified', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'left',
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->end_controls_section();

        // Start Button Widget Style
        $this->start_controls_section(
			'turio_button_widget',
			[
				'label' 		=> esc_html__('Button', 'turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_button_widget_padding',
			[
				'label'      	=> __('Padding', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .button-widget a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_button_widget_margin',
			[
				'label'       	 => __('Margin', 'turio-core'),
				'type'         	 => Controls_Manager::DIMENSIONS,
				'size_units'   	 => ['px', '%'],
				'selectors'      => [
					'{{WRAPPER}} .button-widget a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' 		=> __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __('Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'turio_button_widget_background_color',
			[
				'label' 		=> __('Background Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 			=> 'turio_button_widget_border',
				'label' 		=> __('Border', 'turio-core'),
				'selector' 		=> '{{WRAPPER}} .button-widget a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'button_widget_typography',
				'selector' 		=> '{{WRAPPER}} .button-widget a',

			]
		);

		$this->add_responsive_control(
			'button_widget_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'      	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .button-widget a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' 		=> __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_widget_hover_color',
			[
				'label' 		=> __('Text Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget a:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_widget_hover_bg_color',
			[
				'label' 		=> __('Background Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_widget_hover_border_color',
			[
				'label' 		=> __('Border Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-widget a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'button_widget_hover_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .button-widget a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        $url = $settings['turio_button_widget_url']['url'];
        $target = $settings['turio_button_widget_url']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['turio_button_widget_url']['nofollow'] ? ' rel="nofollow"' : '';
        ?>
            <div class="button-widget  wow animate fadeInUp" data-wow-delay="400ms">
				<?php if (!empty($settings['turio_button_widget_text'])): ?>
					<a  href="<?php echo esc_url( $url ); ?>" <?php echo $target.' '.$nofollow; ?> class="button-fill-primary ">
						<?php if ($settings['turio_button_widget_text']) {
							echo $settings['turio_button_widget_text'];
						} ?>
					</a>
				<?php endif ?>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioButtonWidget() );
