<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioContactgWidget extends Widget_Base {

	public function get_name() {
		return 'turio_contact';
	}

	public function get_title() {
		return esc_html__( 'TX Contact Form', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-map-pin';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// Heading General Section Start

        //Content Section
        $this->start_controls_section(
            'turio_core_contact_section',
            [
                'label' => esc_html__('General', 'turio-core')
            ]
        );

        // Text Control
        $this->add_control(
            'turio_contact_title',
            [
                'label' => esc_html__( 'Title', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Get a free Keystroke quote now', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your title here', 'turio-core' ),
                'label_block' => true,
            ]
        );

        // Description Control
        $this->add_control(
            'turio_contact_description',
            [
                'label' => esc_html__( 'Description', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Your email address will not be published. Required fields are marked *', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your description here', 'turio-core' ),
                'label_block' => true,
            ]
        );

        // Text Control
        $this->add_control(
            'turio_contact_shortcode',
            [
                'label' => esc_html__( 'Shortcode', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your shortcode here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        
        
        $this->end_controls_section();  
        

        // End Heading Description

    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
			
            
        <div class="container">
                <div class="contact-form-wrap">
                    <?php if( !empty( $settings['turio_contact_title'] ) ) :   ?>
                           <h4><?php echo esc_html( $settings['turio_contact_title'] )?></h4>         
                    <?php endif ?>
                    <?php if( !empty( $settings['turio_contact_description']) ) :   ?>
                             <p><?php echo esc_html( $settings['turio_contact_description'] )?></p>       
                    <?php endif ?>

                    <?php if( !empty($settings['turio_contact_shortcode'] ) ) :   ?>
                          <?php echo do_shortcode( $settings['turio_contact_shortcode'] )?>          
                    <?php endif ?>
                    
                </div>
        </div>



        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioContactgWidget() );