<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class turio_image_gallery extends Widget_Base
{

    public function get_name()
    {
        return 'turio_image_gallery';
    }

    public function get_title()
    {
        return esc_html__('TX Gallery', 'turio-core');
    }

    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['turio_widgets'];
    }

    protected function register_controls()
    {
        // Start  Elency Brands Control Section
        $this->start_controls_section(
            'section-general',
            [
                'label' => esc_html__('Content', 'turio-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'caption',
            [
                'label'       => esc_html__('Title', 'turio-core'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Title', 'turio-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'image-gallery',
            [
                'label' => esc_html__('Add Images', 'turio-core'),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'default' => [],
                'description' => 'Max Upload Limit 9 Image',
            ]
        );

        $this->end_controls_section();
        // End Elency Brands Control Section


    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <div class="gallary-area gallary-style-one">
            <div class="container">
                <div class="row">
                    <?php
                    $i = 0;

                    if ($settings['image-gallery']) :
                        foreach ($settings['image-gallery'] as $item) :
                            $i++;
                            $count = count($settings['image-gallery']);
                            if ($i == 1) {
                                echo '<div class="col-lg-4 col-md-4">';
                            }
                    ?>
                            <div class="gallary-item wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($i+1)*2 ?>00ms">
                                <img src="<?php echo esc_url($item['url']) ?>" alt="<?php echo esc_attr('gallery-image') ?>">
                                <a class="gallary-item-overlay" data-fancybox="gallery" data-caption="<?php
                                    if (!empty($settings['caption'])) {
                                        echo $settings['caption'];
                                    }
                                    ?>" href="<?php echo esc_url($item['url']); ?>">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </div>

                    <?php
                            if ($i == $count) {
                                echo '</div>';
                            } elseif ($i % 3 == 0) {
                                echo '</div><div class="col-lg-4 col-md-4">';
                            }
                            if ($i > 8) {
                                break;
                            }
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        </div>
<?php

    }
}

Plugin::instance()->widgets_manager->register(new turio_image_gallery());
