<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Newslatter_Two_Widget extends Widget_Base {

	public function get_name() {
		return 'turio_newsletter_two';
	}

	public function get_title() {
		return esc_html__( 'TX Newslatter Two', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-mail';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// Start Newslatter Two Left Side Content
		$this->start_controls_section(
			'turio_newslatter_two_left_content',
			[
				'label'			=> esc_html__('Left Content')
			]
		);
		$this->add_control(
			'turio_newslatter_two_left_content_title',
			[
				'label'   		=> esc_html__('Title'),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', 'turio-core' ),
				'default' 		=> esc_html__( 'Get 10% Off On <br> <span>Family & Group</span> Tour', 'turio-core' ),
				'label_block' 	=> true, 
			]
		);
        $this->add_control(
            'turio_newslatter_two_left_content_description',
            [
				'label' 			=> esc_html__( 'Description', 'turio-core' ),
				'type' 				=> Controls_Manager::TEXTAREA,
				'placeholder' 		=> esc_html__( 'Enter your description', 'turio-core' ),
				'default' 			=> esc_html__( 'Sign up to receive the best offers on promotion and coupons. Don’t worry! It’s not Spam' ),
            ]
        );
        $this->add_control(
            'turio_newslatter_two_left_content_button',
            [
				'label' 			=> esc_html__( 'Button', 'turio-core' ),
				'type' 				=> Controls_Manager::TEXT,
				'label_block'   	=> true,
				'default' 			=> esc_html__('Explore Now','turio-core'),
                
            ]
        );
		$this->add_control(
			'turio_newslatter_two_left_content_button_link',
			[
				'label' 			=> esc_html__( 'Link', 'turio-core' ),
				'type' 				=> \Elementor\Controls_Manager::URL,
				'placeholder' 		=> esc_html__( 'https://your-link.com', 'turio-core' ),
				'default' 			=> [
					'url' 			=> '#',
					'is_external'	=> true,
					'nofollow'   	=> true,
				],
			]
		);
		$this->add_responsive_control(
			'turio_newslatter_two_left_content_alignment',
			[
				'label' 			=> esc_html__( 'Alignment', 'turio-core' ),
				'type' 				=> Controls_Manager::CHOOSE,
				'options' 			=> [
					'left' 			=> [
						'title' 	=> esc_html__( 'Left', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-left',
					],
					'center' 		=> [
						'title' 	=> esc_html__( 'Center', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-center',
					],
					'right' 		=> [
						'title' 	=> esc_html__( 'Right', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-right',
					],
					'justify' 		=> [
						'title' 	=> esc_html__( 'Justified', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-justify',
					],
				],
				'default' 			=> 'left',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-content' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' 				=> 'turio_newslatter_left_content_background',
				'label' 			=> esc_html__( 'Background', 'turio-core' ),
				'types' 			=> [ 'classic', 'gradient', 'video' ],
				'selector' 			=> '{{WRAPPER}} .newslatter-area .newslatter-offer-side',
			]
		);
		$this->end_controls_section();
		// End Newslatter Two Left Side Content
		// Start Newslatter Two Left Side Content
		$this->start_controls_section(
			'turio_newslatter_two_right_content',
			[
				'label'				=> esc_html__('Right Content'),
				'tab'   			=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_newslatter_two_right_content_title',
			[
				'label'   			=> esc_html__('Title', 'turio-core'),
				'type' 				=> Controls_Manager::TEXT,
				'placeholder' 		=> esc_html__( 'Enter subscription text', 'turio-core' ),
				'default' 			=> esc_html__( 'SUBSCRIBE OUR <span>NEWSLETTER<span>', 'turio-core' ),
				'label_block' 		=> true, 
			]
		);
        $this->add_control(
            'turio_newslatter_two_right_content_description',
            [
				'label' 			=> esc_html__( 'Description', 'turio-core' ),
				'type' 				=> Controls_Manager::TEXTAREA,
				'placeholder' 		=> esc_html__( 'Enter your subscription description', 'turio-core' ),
				'default' 			=> esc_html__( 'Sign up to receive the best offers on promotion and coupons. Don’t worry! It’s not Spam' ),
                
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' 				=> 'turio_newslatter_right_content_background',
				'label' 			=> esc_html__( 'Background', 'turio-core' ),
				'types' 			=> [ 'classic', 'gradient', 'video' ],
				'selector' 			=> '{{WRAPPER}} .newslatter-area .newslatter-form-side',
			]
		);
        $this->add_control(
            'turio_newslatter_two_right_content_shortcode',
            [
				'label' 			=> esc_html__( 'Newslatter Shortcode', 'turio-core' ),
				'type' 				=> Controls_Manager::TEXTAREA,
				'placeholder' 		=> __( 'Enter your newslatter shortcode', 'turio-core' ),
                
            ]
        );
        $this->add_responsive_control(
			'turio_newslatter_two_right_content_alignment',
			[
				'label' 			=> esc_html__( 'Alignment', 'turio-core' ),
				'type' 				=> Controls_Manager::CHOOSE,
				'options' 			=> [
					'left' 			=> [
						'title' 	=> esc_html__( 'Left', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-left',
					],
					'center' 		=> [
						'title' 	=> esc_html__( 'Center', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-center',
					],
					'right' 		=> [
						'title' 	=> esc_html__( 'Right', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-right',
					],
					'justify' 		=> [
						'title' 	=> esc_html__( 'Justified', 'turio-core' ),
						'icon' 		=> 'eicon-text-align-justify',
					],
				],
				'default' 			=> 'left',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-form-content' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		// End Newslatter Two Left Side Content

		// Start Left Content Title Style
		$this->start_controls_section(
			'turio_newslatter_two_left_content_style',
			[
				'label' 			=> esc_html__( 'Left Title', 'turio-core' ),
				'tab' 				=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_newslatter_two_left_content_title_style_color',
			[
				'label' 			=> esc_html__( 'Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
                'default' 			=> '#ffffff',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_newslatter_two_left_content_inner_title_style_color',
			[
				'label' 			=> esc_html__( 'Inner Title Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
                'default' 			=> '#54A15D',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h2 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 			=> esc_html__('Typography','turio-core'),
				'name' 				=> 'turio_newslatter_two_left_content_title_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h2'
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 				=> 'turio_newslatter_two_left_content_title_shadow',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h2,.newslatter-style-two .newslatter-offer-content span'
			]
		);
		$this->end_controls_section();
		// End Left Content Style

		// Start Left Content Description Style
		$this->start_controls_section(
			'turio_newslatter_two_left_content_description_style',
			[
				'label' 			=> esc_html__( 'Left Description', 'turio-core' ),
				'tab' 				=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_newslatter_two_left_content_description_style_color',
			[
				'label' 			=> esc_html__( 'Text Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
                'default' 			=> '#ffffff',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h6' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 			=> esc_html__('Typography','turio-core'),
				'name' 				=> 'turio_newslatter_two_left_content_description_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h6'
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 				=> 'turio_newslatter_two_left_content_description_shadow',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-offer-content h6'
			]
		);
		$this->end_controls_section();
		// Left Button
        $this->start_controls_section(
			'turio_newslatter_two_left_content_button_style',
			[
				'label' 			=> esc_html__('Left Button', 'turio-core'),
				'tab'   			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_newslatter_two_left_content_button_style_padding',
			[
				'label'      		=> __('Padding', 'turio-core'),
				'type'       		=> Controls_Manager::DIMENSIONS,
				'size_units' 		=> ['px', '%'],
				'selectors'  		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_newslatter_two_left_content_button_style_margin',
			[
				'label'        		=> __('Margin', 'turio-core'),
				'type'         		=> Controls_Manager::DIMENSIONS,
				'size_units'   		=> ['px', '%'],
				'selectors'    		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' 			=> __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'turio_newslatter_two_left_content_button_style_color',
			[
				'label' 			=> __('Color', 'turio-core'),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'turio_newslatter_two_left_content_button_style_background_color',
			[
				'label' 			=> __('Background Color', 'turio-core'),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 				=> 'turio_newslatter_two_left_content_button_style_border',
				'label' 			=> __('Border', 'turio-core'),
				'selector' 			=> '{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 			=> esc_html__('Typography', 'turio-core'),
				'name' 				=> 'turio_newslatter_two_left_content_button_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a',

			]
		);

		$this->add_responsive_control(
			'turio_newslatter_two_left_content_button_style_border_radius',
			[
				'label'      		=> __('Border Radius', 'turio-core'),
				'type'       		=> Controls_Manager::DIMENSIONS,
				'size_units' 		=> ['px', '%'],
				'selectors'  		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' 			=> __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' 			=> __('Color', 'turio-core'),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' 			=> __('Background Color', 'turio-core'),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' 			=> __('Border Color', 'turio-core'),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 			=> esc_html__('Typography', 'turio-core'),
				'name' 				=> 'elency_call_to_action_button_hover_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a:hover',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_hover_border_radius',
			[
				'label'     		=> __('Border Radius', 'turio-core'),
				'type'       		=> Controls_Manager::DIMENSIONS,
				'size_units' 		=> ['px', '%'],
				'selectors'  		=> [
					'{{WRAPPER}} .newslatter-area .newslatter-offer-side .explore-btn a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->end_controls_section();
		// End Left Button
		// End Left Content Style
		// Start Right Content Style
		$this->start_controls_section(
			'turio_newslatter_two_right_content_style',
			[
				'label' 			=> esc_html__( 'Right Title', 'turio-core' ),
				'tab' 				=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_newslatter_two_right_content_title_style_color',
			[
				'label' 			=> esc_html__( 'Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-form-content h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_newslatter_two_right_content_inner_title_style_color',
			[
				'label' 			=> esc_html__( 'Inner Title Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-form-content h2 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 			=> esc_html__('Typography','turio-core'),
				'name' 				=> 'turio_newslatter_two_right_content_title_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-form-content h2'
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 				=> 'turio_newslatter_two_right_content_title_shadow',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-form-content h2,.newslatter-style-two .newslatter-form-content span'
			]
		);
		$this->end_controls_section();

		// Start Right Content Description
		$this->start_controls_section(
			'turio_newslatter_two_right_content_description_style',
			[
				'label' 			=> esc_html__( 'Right Description', 'turio-core' ),
				'tab' 				=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_newslatter_two_right_content_description_style_color',
			[
				'label' 			=> esc_html__( 'Text Color', 'turio-core' ),
				'type' 				=> Controls_Manager::COLOR,
                'default' 			=> '#666666',
				'selectors' 		=> [
					'{{WRAPPER}} .newslatter-style-two .newslatter-form-content h6' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 			=> esc_html__('Typography','turio-core'),
				'name' 				=> 'turio_newslatter_two_right_content_description_typography',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-form-content h6'
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 				=> 'turio_newslatter_two_right_content_description_shadow',
				'selector' 			=> '{{WRAPPER}} .newslatter-style-two .newslatter-form-content h6'
			]
		);
		$this->end_controls_section();
		// End Right Content Description

		// End Right Content Style
    }
	protected function render() {
		$settings = $this->get_settings_for_display();

        ?>
	<div class="newslatter-area newslatter-style-two">
        <div class="container-fluid p-0">
            <div class="row g-0">
                <div class="col-lg-6">
                    <div class="newslatter-offer-side">
                        <div class="newslatter-offer-content">
                        	<?php if (!empty($settings['turio_newslatter_two_left_content_title'])): ?>
                        		<h2><?php echo __($settings['turio_newslatter_two_left_content_title'],'turio-core') ?></h2>
                        	<?php endif ?>
                            <?php if (!empty($settings['turio_newslatter_two_left_content_description'])): ?>
                            	<h6><?php esc_html_e($settings['turio_newslatter_two_left_content_description'],'turio-core') ?></h6>
                            <?php endif ?>
                            <?php if (!empty($settings['turio_newslatter_two_left_content_button'])): ?>
	                            <div class="explore-btn">
	                                <a  href="<?php echo esc_url($settings['turio_newslatter_two_left_content_button_link']['url'])?>" <?php echo $settings['turio_newslatter_two_left_content_button_link']['is_external'].' '.$settings['turio_newslatter_two_left_content_button_link']['nofollow'] ?> class="button-fill-round"><?php echo __($settings['turio_newslatter_two_left_content_button'],'turio-core') ?></a>
	                            </div>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="newslatter-form-side">
                        <div class="newslatter-form-content">
                        	<?php if (!empty($settings['turio_newslatter_two_right_content_title'])): ?>
                        		<h2><?php echo __($settings['turio_newslatter_two_right_content_title'],'turio-core'); ?></h2>
                        	<?php endif ?>
                            <?php if ($settings['turio_newslatter_two_right_content_description']): ?>
                            	 <h6><?php echo __($settings['turio_newslatter_two_right_content_description']); ?></h6>
                            <?php endif ?>
                            <?php if (!empty($settings['turio_newslatter_two_right_content_shortcode'])): ?>
                            	<?php echo do_shortcode($settings['turio_newslatter_two_right_content_shortcode']); ?>
                            <?php endif ?>
                        </div>  
                    </div>
                </div>
            </div>
        </div>
    </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new Turio_Newslatter_Two_Widget() );
