<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioSliderWidget extends Widget_Base
{

	public function get_name()
	{
		return 'turio_slider';
	}

	public function get_title()
	{
		return esc_html__('TX Slider One', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{


		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__('General', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_slider_one_image_or_video_selection',
			[
				'label'   => esc_html__('Select Image or Video', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'image_selection'  => esc_html__('Image', 'turio-core'),
					'video_selection' => esc_html__('Video', 'turio-core'),
				],
				'default' => 'image_selection',
			]
		);
		$this->add_control(
			'turio_slider_one_pagination_enable',
			[
				'label' 		=> esc_html__('Show Pagination Bullet', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('Enable', 'turio-core'),
				'label_off' 	=> esc_html__('Disable', 'turio-core'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->end_controls_section();
		//Image Content Start
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__('Slider Items', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'slider_image',
			[
				'label'   => esc_html__('Choose Image', 'turio-core'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'slider_top_title',
			[
				'label'       => esc_html__('Title Tag', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Adventure Tour', 'turio-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'slider_main_title',
			[
				'label'       => esc_html__('Main Title', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Move The Earth', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_description',
			[
				'label'       => esc_html__('Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('Sed convallis sit amet leo quis feugiat. Nunc interdum mollis facilisis. feugi Donec id the urna aliquet, suscipit turpis ut Donec id urna aliquet, suscipit turpis ut, facilisis purus.Sed convallis sit amet leo quis .', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_button_one',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'slider_button_one_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Explore Now', 'turio-core'),
			]
		);

		$repeater->add_control(
			'slider_button_one_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);

		$this->add_control(
			'turio_slider_list_item',
			[
				'label' => __('Slider Items', 'turio-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'slider_main_title'          => 'Move The <span> Earth </span>',
						'slider_main_title_default_active' => 'yes'
					],
					['slider_main_title' => 'Travel & <span> Adventure </span>'],
					['slider_main_title' => 'Move The <span> Earth </span>'],
				],
				'title_field' => '{{slider_main_title}}',
			]
		);


		$this->end_controls_section();

		//Video Content Start
		$this->start_controls_section(
			'video_section_general',
			[
				'label' => esc_html__('Video Section', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'video_selection',
				],
			]
		);

		$this->add_control(
			'video_controller',
			[
				'label' => esc_html__('Choose Video', 'turio-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'turio_video_muted_controller',
			[
				'label' 		=> esc_html__('Muted', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('On', 'turio-core'),
				'label_off' 	=> esc_html__('Off', 'turio-core'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'video_selection',
				],
			]
		);
		$this->add_control(
			'slider_top_video_title',
			[
				'label'       => esc_html__('Title Tag', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Adventure Tour', 'turio-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'slider_video_main_title',
			[
				'label'       => esc_html__('Main Title', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Move The Earth', 'turio-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_video_description',
			[
				'label'       => esc_html__('Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('Sed convallis sit amet leo quis feugiat. Nunc interdum mollis facilisis. feugi Donec id the urna aliquet, suscipit turpis ut Donec id urna aliquet, suscipit turpis ut, facilisis purus.Sed convallis sit amet leo quis .', 'turio-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_video_button_one',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'slider_video_button_one_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Explore Now', 'turio-core'),
			]
		);

		$this->add_control(
			'slider_video_button_one_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);
		$this->end_controls_section();


		// Title tag Style
		$this->start_controls_section(
			'slider_main_title_tag_style',
			[
				'label' => esc_html__('Title Tag', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_main_title_tag_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-content.position-relative h5' => 'color: {{VALUE}} ;',
					'{{WRAPPER}} .home-one-hero .hero-content h5' => 'color: {{VALUE}} ;',
				],
				'default'   => '#05E62A'
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'main_title_tag_typography',
				'selector' => '{{WRAPPER}} .hero-content.position-relative h5,.home-one-hero .hero-content h5',

			]
		);
		$this->add_responsive_control(
			'turio_main_title_tag_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-content.position-relative h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_main_title_tag_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-content.position-relative h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();



		//Main Title Style
		$this->start_controls_section(
			'slider_main_title_style',
			[
				'label' => esc_html__('Main Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_main_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .swiper-slide.swiper-slide-active .hero-single-slide .hero-content-bg .hero-content h2' => 'color: {{VALUE}} ;',
					'{{WRAPPER}} .home-one-hero .hero-content h2' => 'color: {{VALUE}} ;',
				],
			]
		);

		$this->add_control(
			'turio_main_title_color_two',
			[
				'label'     => esc_html__('Color Two', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .swiper-slide.swiper-slide-active .hero-single-slide .hero-content-bg .hero-content h2.hero-title span' => '-webkit-text-stroke-color: {{VALUE}} ;',
					'{{WRAPPER}} .home-one-hero .hero-content h2 span' => '-webkit-text-stroke-color: {{VALUE}} ;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'main_title_typography',
				'selector' => '{{WRAPPER}} .hero-style-one .swiper-slide.swiper-slide-active .hero-single-slide .hero-content-bg .hero-content h2,.home-one-hero .hero-content h2',

			]
		);
		$this->add_responsive_control(
			'turio_main_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'turio_main_title_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Description Style
		$this->start_controls_section(
			'slider_description_style',
			[
				'label' => esc_html__('Description', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .swiper-slide.swiper-slide-active .hero-single-slide .hero-content-bg .hero-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .home-one-hero .hero-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .hero-style-one .swiper-slide.swiper-slide-active .hero-single-slide .hero-content-bg .hero-content p,.home-one-hero .hero-content p',

			]
		);
		$this->add_responsive_control(
			'turio_description_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'turio_description_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Start Button Widget Style
		$this->start_controls_section(
			'turio_button_widget',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_button_widget_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content .hero-btns a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'turio_button_widget_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content .hero-btns a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary' => 'color: {{VALUE}};',
					'{{WRAPPER}} .home-one-hero .hero-content .hero-btns a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'turio_button_widget_background_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .home-one-hero .hero-content .hero-btns a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'turio_button_widget',
				'label' => __('Border', 'turio-core'),
				'selector' => '{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary,.home-one-hero .hero-content .hero-btns a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_typography',
				'selector' => '{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary,.home-one-hero .hero-content .hero-btns a',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-one-hero .hero-content .hero-btns a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} a.button-fill-primary:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary:hover' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} a.button-fill-primary:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary:hover' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} a.button-fill-primary:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_hover_typography',
				'selector' => '{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary:hover',
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'image_selection',
				],

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_hover_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-one .hero-single-slide .hero-content-bg .hero-content .hero-btns a.button-fill-primary:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'condition' => [
						'turio_slider_one_image_or_video_selection' => 'image_selection',
					],
					
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		// Pagination Style
		$this->start_controls_section(
			'slider_pagination_style',
			[
				'label' => esc_html__('Pagination Bullet', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_slider_one_image_or_video_selection' => 'image_selection',
				],

			]
		);
		$this->add_control(
			'pagination_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-one .slider-one-pagination span.swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .hero-style-one .slider-one-pagination span.swiper-pagination-bullet-active::before' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (is_admin()) {
			?>
			<script>
				(function($) {

					var heroSlider = new Swiper(".hero-slider-one", {
						slidesPerView: 1,
						speed: 1500,
						spaceBetween: 0,
						loop: true,
						effect: "fade",

						centeredSlides: true,
						roundLengths: true,
						fadeEffect: {
							crossFade: true,
						},
						autoplay: {
							delay: 7000,
						},
						pagination: {
							el: ".slider-one-pagination",
							type: "bullets",
							clickable: true,
						},
					});
				})(jQuery);
			</script>
		<?php
				}
				?>
		<?php if (!empty($settings['turio_slider_one_image_or_video_selection']) && ($settings['turio_slider_one_image_or_video_selection'] == 'image_selection')) : ?>
			<div class="hero-area hero-style-one overflow-hidden ">
				<div class="container-fluid p-0">
					<div class="swiper hero-slider-one">
						<div class="swiper-wrapper">
							<?php
							if (!empty($settings['turio_slider_list_item'])) {
								foreach ($settings['turio_slider_list_item'] as $item) {
									$btn_url_one = $item['slider_button_one_url']['url'];
									$btn_target_one = $item['slider_button_one_url']['is_external'] ? ' target="_blank" ' : '';
									$btn_nofollow_one = $item['slider_button_one_url']['nofollow'] ? ' rel="nofollow"' : '';
									?>
									<div class="swiper-slide">
										<div class="hero-single-slide">
											<div class="hero-highlighted-bg">
												<?php // echo '<img src="' . $item['slider_image']['url'] . '" alt="travel-image">'; 
																	?>
											</div>
											<div class="hero-content-bg" style="background-image: url('<?php echo $item['slider_image']['url'] ?>');">
												<div class="container">
													<div class="hero-content position-relative">
														<?php if (!empty($item['slider_top_title'])) :   ?>
															<h5><?php echo esc_html($item['slider_top_title']) ?></h5>
														<?php endif ?>
														<?php
															if (!empty($item['slider_main_title'])) {
																echo '<h2 class="hero-title">' . $item['slider_main_title'] . '</h2>';
															}

															if (!empty($item['slider_description'])) {
																echo '<p>' . esc_html($item['slider_description']) . '</p>';
															}
															?>

														<div class="hero-btns">

															<?php
																if (!empty($btn_url_one)) {
															?>
																<a class="button-fill-primary" href="<?php echo esc_url($btn_url_one) ?>" <?php echo esc_attr($btn_target_one . ' ' . $btn_nofollow_one) ?>>
																	<?php
																		echo $item['slider_button_one_text'];
																	?>	
																</a>
															<?php
																}
															?>

														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
							<?php
								}
							}
							?>
						</div>
					</div>
				</div>
				<?php if (!empty($settings['turio_slider_one_pagination_enable']) && $settings['turio_slider_one_pagination_enable'] == 'yes') : ?>
					<div class="slider-one-pagination text-center"></div>
				<?php endif ?>
			</div>
		<?php endif ?>

		<?php if (!empty($settings['turio_slider_one_image_or_video_selection']) && ($settings['turio_slider_one_image_or_video_selection'] == 'video_selection')) : ?>
			<?php

				$btn_url_one = $settings['slider_video_button_one_url']['url'];
				$btn_target_one = $settings['slider_video_button_one_url']['is_external'] ? ' target="_blank" ' : '';
				$btn_nofollow_one = $settings['slider_video_button_one_url']['nofollow'] ? ' rel="nofollow"' : '';
				?>

				<div class="home-one-hero">
					<div class="video-wrap">
						<video autoplay
						loop="loop"
						<?php echo $settings['turio_video_muted_controller'] == 'yes' ? 'muted' : '' ?>  
						preload="auto">
							<?php if (!empty($settings['video_controller']['url'] )) :   ?>
								<source src="<?php echo $settings['video_controller']['url'] ?>" type="video/mp4">
							<?php endif ?>
						</video>
						<div class="hero-content">
							<?php if (!empty($settings['slider_top_video_title'])) :   ?>
								<h5><?php echo esc_html($settings['slider_top_video_title']) ?></h5>
							<?php endif ?>
							<?php
								if (!empty($settings['slider_video_main_title'])) {
									echo '<h2 class="hero-title">' . $settings['slider_video_main_title'] . '</h2>';
								}

								if (!empty($settings['slider_video_description'])) {
									echo '<p>' . esc_html($settings['slider_video_description']) . '</p>';
								}
								?>

							<div class="hero-btns">

								<?php
									if (!empty($settings['slider_video_button_one_text'])) {
								?>
									<a class="button-fill-primary" href="<?php echo esc_url($btn_url_one) ?>" <?php echo esc_attr($btn_target_one . ' ' . $btn_nofollow_one) ?>>
										<?php
										echo $settings['slider_video_button_one_text'];
										?>
									</a>
								<?php
									}
								?>

							</div>
						</div>
					</div>
				</div>

		<?php endif ?>
<?php
	}
}

Plugin::instance()->widgets_manager->register(new TurioSliderWidget());
