<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Testimonial_Three extends Widget_Base {

	public function get_name() {
		return 'turio_testimonial_three';
	}

	public function get_title() {
		return esc_html__( 'TX Testimonial Three', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}
	protected function register_controls() {

		// Testimonial Header Section Start
		$this->start_controls_section(
			'turio_testimonial_three_header_setting',
			[
				'label' 		=> esc_html__('Header Settings','turio-core'),
				'tab' 			=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		// Start Header Section Switcher Option
		$this->add_control(
			'turio_testimonial_three_title_switcher',
			[
				'label' 		=> esc_html__( 'Show Title', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_testimonial_three_rating_switcher',
			[
				'label' 		=> esc_html__( 'Show Rating', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value'  => 'yes',
				'default' 		=> 'yes',
			]
		);
		// End Header Section Switcher Option
		$this->add_control(
            'turio_testimonial_three_title',
            [
                'label' 		=> esc_html__( 'Title', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> esc_html__( 'What Our Travelar Say', 'turio-core' ),
                'label_block' 	=> true,
         
        	]
        );
		$this->end_controls_section();

		// Testimonial Header Section End
		// Testimonial General Settings
		$this->start_controls_section(
			'turio_testimonial_three_general_setting',
			[
				'label'  		=> esc_html__('General','turio-core'),
				'tab'    		=> Controls_Manager::TAB_CONTENT
			]
		);
		 $this->add_control(
			'turio_testimonial_icon',
			[
				'label' 		=> esc_html__( 'Choose Quote Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::ICONS,
				'default' 		=> [
					'value' 	=> 'bx bxs-quote-left',
					'library' 	=> 'solid',
				],
                'label_block' 	=> true
			]
		);
		$this->end_controls_section();
		// End Testimonial General Settings


		// Testimonial Lists Section Start
		$this->start_controls_section(
			'turio_testimonial_lists',
			[
				'label' 		=> esc_html__( 'Testimonial Lists', 'turio-core' )
			]
		);

        $repeater = new Repeater();
		$repeater->add_control(
			'turio_testimonial_author_image',
			[
				'label'   		=> esc_html__( 'Author Image', 'turio-core' ),
				'type'    		=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'turio_testimonial_author_name',
			[
				'label'       	=> esc_html__( 'Name', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXT,
				'default'     	=> esc_html__( 'John Due', 'turio-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'turio_testimonial_author_designation',
			[
				'label'       	=> esc_html__( 'Designation', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXT,
				'default'     	=> esc_html__( 'Traveler', 'turio-core' ),
				'label_block' 	=> true,
			]
		);

		// Rating Start

		$repeater->add_control(
			'turio_testimonial_three_rating',
			[
				'label' 		=> esc_html__( 'Rating', 'turio-core' ),
				'type' 			=> Controls_Manager::NUMBER,
				'min' 			=> 0,
				'max' 			=> 5,
				'step' 			=> 1,
				'default' 		=> 5,
				'dynamic' 		=> [
					'active' 	=> true,
				],
			]
		);

		// Rating Start End
        $repeater->add_control(
			'turio_testimonial_author_description',
			[
				'label'       	=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'default'     	=> esc_html__( 'but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages', 'turio-core' ),
			]
		);

		$this->add_control(
			'turio_testimonial_list',
			[
				'label' 		=> __( 'Testimonial List', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default'		=> [
					[
						'turio_testimonial_author_name'     => esc_html__( 'Adam Groff', 'turio-core' ),
						'turio_brand_item_default_active'   => 'yes'
					],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Lilyan Danclark', 'turio-core' ) ],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Shwan Pull', 'turio-core' ) ],
				],
				'title_field'   => '{{turio_testimonial_author_name}}'
			  ,
			]
		);

		$this->end_controls_section();

		// Testimonial Lists Section End

		// Start Testimonial three Style
		$this->start_controls_section(
			'turio_testimonial_background_style',
			[
				'label'  		=> esc_html__('Background'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		); 
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' 			=> 'background',
				'label' 		=> esc_html__( 'Background', 'turio-core' ),
				'types' 		=> [ 'classic', 'gradient', 'video' ],
				'selector' 		=> '{{WRAPPER}} .testimonial-style-three',
			]
		);
		$this->end_controls_section();
		//Box Settings Start
		$this->start_controls_section(
			'turio_testimonial_three_box_setting_style',
			[
				'label'  		=> esc_html__('Box Setting'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		);
		$this->add_control(
			'turio_testimonial_three_box_setting_background',
			[
				'label'  		=> esc_html__('Background Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma' => 'background : {{VALUE}}',
				]
			]
		);
		 
		$this->add_responsive_control(
			'turio_testimonial_three_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .testimonial-card-gamma' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		 $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_package_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .testimonial-card-gamma',
			]
		);
		$this->end_controls_section();

		// Start Testimonial Title Style
		$this->start_controls_section(
			'turio_testimonial_three_title_style',
			[
				'label'   		=> esc_html__('Title','turio-core'),
				'tab'     		=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                'turio_testimonial_three_title_switcher' => 'yes',
            	]   
			]
		);
		$this->add_control(
			'turio_testimonial_three_title_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'default' 		=> '#fff',
				'selectors' 	=> [
					'{{WRAPPER}} .section-head-testimonial-three h2' => 'color: {{VALUE}};',
				],

			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_three_title_style_typography',
				'selector' 		=> '{{WRAPPER}} .section-head-testimonial-three h2',

			]
		);
        $this->add_responsive_control(
			'turio_testimonial_three_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .section-head-testimonial-three h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_responsive_control(
            'turio_testimonial_three_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .section-head-testimonial-three h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
		// End Testimonial Title Style

		// Start Quote Icon Style
		$this->start_controls_section(
			'turio_testimonial_three_icon_style',
			[
				'label' 		=> esc_html__( 'Quote Icon', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,

			]
		);
        $this->add_control(
			'turio_testimonial_three_icon_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-quote-icon i'   => 'color: {{VALUE}};',
          			'{{WRAPPER}} .testimonial-card-gamma .testimonial-quote-icon svg path' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_three_icon_style_size',
			[
				'label' 		=> esc_html__( 'Width', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 200,
						'step' 	=> 2,
					],
					'%' => [
						'min' 	=> 0,
						'max' 	=> 100,
					],
				],
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-quote-icon i'   => 'font-size:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-quote-icon svg' => 'width:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-quote-icon svg' => 'height:  {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Quote Icon Style
		// Name Style
		$this->start_controls_section(
			'turio_testimonial_three_author_name_style',
			[
				'label' 		=> esc_html__( 'Name', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_name_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewr-info .reviewer-name' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_three_author_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewr-info .reviewer-name',

			]
		);
		

		$this->end_controls_section();


		// Designation Style
		$this->start_controls_section(
			'turio_testimonial_three_author_designation_style',
			[
				'label' 		=> esc_html__( 'Designation', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_designation_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewr-info p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_three_author_designation_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewr-info p',

			]
		);
		
		$this->end_controls_section();


		// Description Style
		$this->start_controls_section(
			'turio_testimonial_author_description_style',
			[
				'label' 		=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_description_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .review-texts p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_author_description_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .review-texts p',

			]
		);

	
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		// Start Rating Control Style
		$this->start_controls_section(
			'turio_testimonial_rating_control_style',
			[
				'label' 		=> esc_html__('Rating','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_testimonial_three_rating_switcher'  	=> 'yes'
				]
			]
		);
		$this->add_control(
			'turio_testimonial_rating_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewer-rating .bi' => 'color: {{VALUE}};',
				],
			]
		);
 		$this->add_control(
			'turio_testimonial_rating_icon_style_size',
			[
				'label' 		=> esc_html__( 'Size', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 1,
					]
				],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> 16,
				],
                'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-gamma .testimonial-card-body .testimonial-info .reviewer-rating .bi' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Rating Control Style

	}
	
	protected function render() {

		$settings = $this->get_settings_for_display(); 

		if (is_admin()) {
			?>
			<script>
		    (function ($) {
				var testimonialSliderOne = new Swiper('.testimonial-slider-three', {
					slidesPerView: 1,
					speed: 1000,
					spaceBetween: 20,
					loop: true,
					roundLengths: true,
					autoplay: {
					delay: 15000
					},
					navigation: {
					nextEl: '.testi-next',
					prevEl: '.testi-prev',
					},
					// breakpoints: {
					//   480:{
					//     slidesPerView: 1
					//   },
					//   768:{
					//     slidesPerView: 1
					//   },
					//   992:{ 
					//     slidesPerView: 2
					//   },
					//   1200:{
					//     slidesPerView: 1
					//   },
					
					// }
				});
		    })(jQuery);
			</script>
		<?php
		}
		?>

        <div class="testimonial-area testimonial-style-three pt-110 pb-110">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-head-testimonial-three">
                            <?php if (!empty($settings['turio_testimonial_three_title']) && $settings['turio_testimonial_three_title_switcher'] == 'yes'): ?>
                                <h2><?php  echo $settings['turio_testimonial_three_title'] ?></h2>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-12">
                        <div class="swiper testimonial-slider-three">
                            <div class="swiper-wrapper">
                                <?php 
                                $k = 0;
                                if(!empty($settings['turio_testimonial_list'])) :

                                    foreach ( $settings['turio_testimonial_list'] as $item ) :
                                    $k++;
                                ?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-card-gamma mx-auto">
                                            <?php if (!empty($settings['turio_testimonial_icon'])): ?>
                                                <div class="testimonial-quote-icon">
													<?php \Elementor\Icons_Manager::render_icon( $settings['turio_testimonial_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                </div>
                                            <?php endif ?>
                                            <div class="testimonial-card-body">
                                                <?php if (!empty($item['turio_testimonial_author_description'])): ?>
                                                    <div class="review-texts">                                               
                                                        <p>
                                                            <?php echo esc_html__( $item['turio_testimonial_author_description'] ) ?>
                                                        </p>                                               
                                                    </div>
                                                <?php endif ?>
                                                <div class="testimonial-info">
                                                    <div class="reviewr-info">
                                                        <?php if(!empty($item['turio_testimonial_author_image'])) : ?>
                                                            <div class="single-thumb">
                                                                <img src="<?php echo esc_url($item['turio_testimonial_author_image']['url']); ?>" alt="<?php echo esc_attr__('author-image','turio-core')?>">
                                                            </div>
                                                        <?php endif ?>
                                                        <div class="reviwer-info-cotn">
                                                            <?php if(!empty($item['turio_testimonial_author_name'])) : ?>
                                                                <h5 class="reviewer-name"><?php echo esc_html__( $item['turio_testimonial_author_name'] ); ?></h5>
                                                            <?php endif ?>
                                                            <?php if(!empty($item['turio_testimonial_author_designation'])) : ?>    
                                                                <p><?php echo esc_html( $item['turio_testimonial_author_designation'] ) ?></p>
                                                            <?php endif ?>
                                                        </div>
                                                    </div>
                                                    <?php if (!empty($settings['turio_testimonial_three_rating_switcher']) && $settings['turio_testimonial_three_rating_switcher'] == 'yes'): ?>
                                                        <ul class="reviewer-rating gap-2">
                                                            <?php
                                                                for ($i=0; $i <$item['turio_testimonial_three_rating'] ; $i++) {  ?>
                                                                <li><i class="bi bi-star-fill"></i></li>	
                                                            <?php	}
                                                            ?>
                                                        </ul>
                                                    <?php endif ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	<?php	
    }
}

Plugin::instance()->widgets_manager->register( new Turio_Testimonial_Three() );
