<?php
/*
Plugin Name: Turio Core
Plugin URI: https://themeforest.net/user/egenslab/portfolio
Description: This Plugin Integrate by contain short codes, custom post types, Elementor Widgets, Custom Widget and more of the Turio theme.
Author: Egens Lab
Author URI: https://themeforest.net/user/egenslab/
Version: 1.4.0
Text Domain: turio-core
*/

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
//Check turio active or not
$theme_name_array   = array('Turio', 'Turio Child');
$current_theme      = wp_get_theme();
$current_theme_name = $current_theme->get('Name');
define('TURIO_THEME_ACTIVE', in_array($current_theme_name, $theme_name_array) ? true : false);

//plugin dir path
define('TURIO_CORE_ENV', true);
define('TURIO_CORE_ROOT_PATH', plugin_dir_path(__FILE__));
define('TURIO_CORE_ROOT_URL', plugin_dir_url(__FILE__));
define('TURIO_CORE_SELF_PATH', 'turio-core/turio-core.php');
define('TURIO_CORE_VERSION', '1.0.0');
define('TURIO_CORE_INC', TURIO_CORE_ROOT_PATH . '/inc');
define('TURIO_CORE_LIB', TURIO_CORE_ROOT_PATH . '/library');
define('TURIO_CORE_ELEMENTOR', TURIO_CORE_ROOT_PATH . '/elementor');
define('TURIO_CORE_DEMO_IMPORT', TURIO_CORE_ROOT_PATH . '/demo-data-import');
define('TURIO_CORE_ADMIN', TURIO_CORE_ROOT_PATH . '/admin');
define('TURIO_CORE_ADMIN_ASSETS', TURIO_CORE_ROOT_URL . 'admin/assets');
define('TURIO_CORE_WP_WIDGETS', TURIO_CORE_ROOT_PATH . '/wp-widgets');
define('TURIO_CORE_ASSETS', TURIO_CORE_ROOT_URL . 'assets/');
define('TURIO_CORE_CSS', TURIO_CORE_ASSETS . 'css');
define('TURIO_CORE_JS', TURIO_CORE_ASSETS . 'js');
define('TURIO_CORE_FONT', TURIO_CORE_ASSETS . 'font');
define('TURIO_CORE_FONTS', TURIO_CORE_ASSETS . 'fonts');
define('TURIO_CORE_IMG', TURIO_CORE_ASSETS . 'images');


//Helper Functions
if (file_exists(TURIO_CORE_INC . '/class-turio-core-helper-functions.php')) {
    require_once TURIO_CORE_INC . '/class-turio-core-helper-functions.php';
    if (!function_exists('turio_core')) {
        function turio_core()
        {
            return class_exists('Turio_Core_Helper_Functions') ? new Turio_Core_Helper_Functions() : false;
        }
    }
}

//load codester framework functions
if (!TURIO_THEME_ACTIVE) {
    if (file_exists(TURIO_CORE_ROOT_PATH . '/inc/csf-functions.php')) {
        require_once TURIO_CORE_ROOT_PATH . '/inc/csf-functions.php';
    }
}

//plugin init
if (file_exists(TURIO_CORE_ROOT_PATH . '/inc/class-turio-core-init.php')) {
    require_once TURIO_CORE_ROOT_PATH . '/inc/class-turio-core-init.php';
}


require_once TURIO_CORE_DEMO_IMPORT . '/demo-importer.php';
