<?php

//Contact Details Custom Widget

class Turio_Contact_Details extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'turio_contact_details',

            // Widget name
            __('Turio Contact Details', 'turio-core'),

            // Widget description
            array('description' => __('Turio Contact Details', 'turio-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
?>

        <?php if (!empty($title)) : ?>
            <?php echo $args['before_title'] . esc_attr(__($title, 'turio-core')) . $args['after_title']; ?>
        <?php endif; ?>
        <?php if (!empty($instance['phone_one'] || !empty($instance['phone_two']))) : ?>
            <div class="number">
                <div class="num-icon">
                    <i class="bi bi-telephone"></i>
                </div>
                <div class="phone">
                    <?php if (!empty($instance['phone_one'])) : ?>
                        <a href="tel:<?php echo  esc_html($instance['phone_one'], 'turio-core') ?>"><?php echo  esc_html(__($instance['phone_one'], 'turio-core')); ?></a>
                    <?php endif; ?>
                    <?php if (!empty($instance['phone_two'])) : ?>
                        <a href="tel:<?php echo  esc_html($instance['phone_two'], 'turio-core') ?>"><?php echo  esc_html(__($instance['phone_two'], 'turio-core')); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif ?>
        <?php if (!empty($instance['email_one'] || !empty($instance['email_two']))) : ?>
            <div class="office-mail">
                <div class="mail-icon">
                    <i class="bi bi-envelope-fill"></i>
                </div>
                <div class="email">
                    <?php if (!empty($instance['email_one'])) : ?>
                        <a href="<?php echo  esc_url('mailto:' . $instance['email_one']) ?>"><?php echo  esc_html(__($instance['email_one'], 'turio-core')); ?></a>
                    <?php endif; ?>
                    <?php if (!empty($instance['email_two'])) : ?>
                        <a href="<?php echo  esc_url('mailto:' . $instance['email_two']) ?>"><?php echo  esc_html(__($instance['email_two'], 'turio-core')); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif ?>
        <?php if (!empty($instance['address_one'] || !empty($instance['address_two']))) : ?>
        <div class="address">
            <div class="address-icon">
                <i class="bi bi-geo-alt"></i>
            </div>
            <div class="contact">
                <?php if (!empty($instance['address_one'])) : ?>
                    <p><?php echo $instance['address_one'] ?> </p>
                <?php endif; ?>
                <?php if (!empty($instance['address_two'])) : ?>
                    <p><?php echo $instance['address_two'] ?> </p>
                <?php endif; ?>
            </div>
        </div>
        <?php endif ?>

    <?php
        echo $args['after_widget'];
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        $phone_one = '';
        if (isset($instance['phone_one'])) {
            $phone_one = $instance['phone_one'];
        }
        $phone_two = '';
        if (isset($instance['phone_two'])) {
            $phone_two = $instance['phone_two'];
        }
        $email_one = '';
        if (isset($instance['email_one'])) {
            $email_one = $instance['email_one'];
        }
        $email_two = '';
        if (isset($instance['email_two'])) {
            $email_two = $instance['email_two'];
        }
        $address_one = '';
        if (isset($instance['address_one'])) {
            $address_one = $instance['address_one'];
        }
        $address_two = '';
        if (isset($instance['address_two'])) {
            $address_two = $instance['address_two'];
        }
    ?>


        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phone_one'); ?>"><?php _e('Phone Primary:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('phone_one'); ?>" name="<?php echo $this->get_field_name('phone_one'); ?>" type="text" value="<?php echo esc_attr($phone_one); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phone_two'); ?>"><?php _e('Phone Secondery:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('phone_two'); ?>" name="<?php echo $this->get_field_name('phone_two'); ?>" type="text" value="<?php echo esc_attr($phone_two); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email_one'); ?>"><?php _e('Email Primary:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email_one'); ?>" name="<?php echo $this->get_field_name('email_one'); ?>" type="text" value="<?php echo esc_attr($email_one); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email_two'); ?>"><?php _e('Email Secondery:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email_two'); ?>" name="<?php echo $this->get_field_name('email_two'); ?>" type="text" value="<?php echo esc_attr($email_two); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('address_one'); ?>"><?php _e('Address One:', 'turio-core'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('address_one'); ?>" name="<?php echo $this->get_field_name('address_one'); ?>" value="<?php echo esc_attr($address_one); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('address_two'); ?>"><?php _e('Address Two:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('address_two'); ?>" name="<?php echo $this->get_field_name('address_two'); ?>" type="text" value="<?php echo esc_attr($address_two); ?>">
        </p>

<?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['phone_one'] = (!empty($new_instance['phone_one'])) ? strip_tags($new_instance['phone_one']) : '';
        $instance['phone_two'] = (!empty($new_instance['phone_two'])) ? strip_tags($new_instance['phone_two']) : '';
        $instance['email_one'] = (!empty($new_instance['email_one'])) ? strip_tags($new_instance['email_one']) : '';
        $instance['email_two'] = (!empty($new_instance['email_two'])) ? strip_tags($new_instance['email_two']) : '';
        $instance['address_one'] = (!empty($new_instance['address_one'])) ? strip_tags($new_instance['address_one']) : '';
        $instance['address_two'] = (!empty($new_instance['address_two'])) ? strip_tags($new_instance['address_two']) : '';
        return $instance;
    }
}
if (!function_exists('Turio_Contact_Details')) {
    function Turio_Contact_Details()
    {
        register_widget('Turio_Contact_Details');
    }
    add_action('widgets_init', 'Turio_Contact_Details');
}
