<?php


class Turio_Popular_Package_Widget extends WP_Widget
{

	function __construct()
	{
		parent::__construct(

			// Base ID of our widget
			'turio_popular_tour_package',

			// Widget name
			__('Turio Popular Package', 'turio-core'),

			// Widget description
			array('description' => __('Turio Popular Package', 'turio-core'),)
		);
	}

	public function widget($args, $instance)
	{
		$title = apply_filters('widget_title', $instance['title']);
?>
		<aside class="package-widget-style-2 widget-recent-package-entries mt-30">
			<div class="widget-title text-center">
			<?php
			if (!empty($title)) {
			?>
				<h4><?php echo  esc_attr(__($title, 'turio-core')); ?></h4>
			<?php
			}
			?>
			</div>
			<div class="widget-body">
				<ul>
					<?php
					$dont_show_me = array(1);
					$args = array(
						'post_type' 	=> 'turio-package',
						'meta_query' 	=> array(
							array(
								'key' 		=> 'turio_feature_package_options',
								'compare' 	=> 'LIKE',
								'value' 	=> true,
								'type' 		=> 'boolean'
							)
						),
						'posts_per_page'	=> 5,
						'meta_key' 			=> 'turio_feature_package_options',
						'orderby' 			=> 'meta_value_num',
						'order' 			=> 'DESC',
						'post__not_in' => $dont_show_me
					);

					$query = new WP_Query($args); 

					//loop 
					while ($query->have_posts()) :
						$query->the_post();

						$package_info = get_post_meta(get_the_ID(), 'turio_turio_package_info_options', true);
					?>
						<li class="package-sm">
							<?php
								if (has_post_thumbnail()) :
								?>
							<div class="thumb">
								<a href="<?php the_permalink(); ?>">
									<?php the_post_thumbnail(array(80, 80), array('class' => 'img-fluid')); ?>
								</a>
							</div>
							<?php endif; ?>
							<div class="info">
								<h6><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h6>
								<div class="price">
									<span><?php echo __('From','turio-core') ?></span>
									<h6>
									<?php
										if (!empty($package_info['tp_price']) && !empty($package_info['tp_promotion_price'])) {
										?>
											<del><?php echo esc_html($package_info['tp_price']) ?></del>
											<?php echo esc_html('- ' . $package_info['tp_promotion_price']) ?>
										<?php
										} elseif (!empty($package_info['tp_price'])) {
										?>
											<?php echo esc_html($package_info['tp_price']) ?>
										<?php
										}
										?>
										<?php
										if (!empty($package_info['tp_price_type'])) :
											echo __('/' .'<span>'.$package_info['tp_price_type'].'</span>');
										endif;
									?>
									</h6>
								</div>
							</div>
						</li>
					<?php endwhile; ?>
				</ul>
			</div>
		</aside>
		<?php wp_reset_query(); ?>
	<?php
	}

	// Widget Backend
	public function form($instance)
	{
		$title = '';
		if (isset($instance['title'])) {
			$title = $instance['title'];
		}
	?>
		<!--Title-->
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
<?php
	}

	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
		return $instance;
	}
}

if (!function_exists('Turio_Popular_Package_Widget')) {
	function Turio_Popular_Package_Widget()
	{
		register_widget('Turio_Popular_Package_Widget');
	}
	add_action('widgets_init', 'Turio_Popular_Package_Widget');
}
