jQuery(document).ready(function(){
 function {{uc_id}}_start() {	
		
  var jQuerytabs = jQuery('#{{uc_id}}');
  var htmlAccordion = jQuerytabs.find(".uc-accordion-contents-template").html();  
  var objTabs = jQuerytabs.find(".ue-tab-btn");
  
  var g_dataScrollToHashedTab = jQuerytabs.data("hash-scroll");
  var g_scrollOffset = jQuerytabs.data("scroll-to-selected-tab-offset");

  var objElementorTabs = jQuery(".e-n-tabs .e-n-tab-title");
  
  var tabsOptions = {
    
      startCollapsed: '{{start_hidden}}',
      {% if accordion_breakpoint == "true" %}
        collapsible: 'accordion',
       closeCurrent: true,
      {% else %}
        collapsible: 'tabs',
        closeCurrent: {{close_active_tab_on_click}},  
      {% endif %}      
      setHash: {{set_url_hash}},
      accordionAnchorHTML:htmlAccordion ,
      breakpoint: {{responsive_breakpoint}},
       
  }
  
  //tabs must ne inited before remote script
  jQuerytabs.responsiveContentTabs('init', tabsOptions);
   
  /**
  * before - after widget template tab fix
  */  
  jQuerytabs.on("click", function(){
  
  	var objBeforeAfterWidgets = jQuerytabs.find(".cocoen");
  
    if(!objBeforeAfterWidgets.length){
    	
      var objConnectedElements = jQuerytabs.find(".ue-element");
      
      if(objConnectedElements){
        objConnectedElements.each(function(){
      
          var objElement = jQuery(this);
          var dataId = objElement.data("id");
          var objConnectedBeforeAfterWidget = jQuery("#"+dataId).find(".cocoen");

          if(!objConnectedBeforeAfterWidget)
          return(true);  

          objConnectedBeforeAfterWidget.trigger("delayed_start");
        });
      }      
    
    }else
   	objBeforeAfterWidgets.trigger("delayed_start"); 
   
  });
  
  /**
  * scrolls the page
  */  
  function scrollToTop(elementOffsetTop, offset){
     jQuery('html, body').animate({       
       scrollTop: elementOffsetTop + offset                                  
     }, 400);    
  }

  /**
  * scrolls to head in responsive mode
  */  
  function initScrollOption(){

    {% if scroll_to_head == "true" %}

      var objTab = jQuerytabs.find('.r-tabs-anchor');
      var isMobileViewport = window.matchMedia("(max-width: " + {{responsive_breakpoint}} + "px)");

      objTab.click(function(){
        
          var jQuerytabsOffsetTop = jQuerytabs.offset().top;
          var tabsItemOffsetTop = jQuery(this).offset().top;

          if(isMobileViewport.matches == true)
              scrollToTop(tabsItemOffsetTop, {{scroll_to_head_offset}});
        
      });

    {% endif %}
  
  }
     
  /**
  * returns jQuery object of the hashed tab
  */     
  function getHashedTab(){  
  	if (!window.location.hash) 
    return false;

    var hash = window.location.hash.replace("#", "");
    
    var objHash = jQuery("[data-hash-id="+hash+"]");
  
    return(objHash);  
  }   
     
  /**
  * scrolls to tab with different g_dataScrollToHashedTab values
  */     
  function scrollToTab(objTab){  
    var objTabTop = objTab.offset().top;
    
    if (g_dataScrollToHashedTab == "desktop" && window.matchMedia("(min-width: 1024px)").matches)
      scrollToTop(objTabTop, g_scrollOffset);
    
    if (g_dataScrollToHashedTab == "mobile" && window.matchMedia("(max-width: 1024px)").matches)
	  scrollToTop(objTabTop, g_scrollOffset);
    
    if (g_dataScrollToHashedTab == "desktop+mobile")
      scrollToTop(objTabTop, g_scrollOffset);  
  }   
     
  /**
  * scrolls to hashed tab after page load
  */  
  function scrollToHashedTab(){  
  	var dataHash = jQuerytabs.data("hash");
    
    if(dataHash == false)
    return(false);
        
    if(g_dataScrollToHashedTab == "off")
    return(false); 
    
    var objHash = getHashedTab();
    
    if(!objHash || !objHash.length || objHash == false)
    return(false); 
      
    var objHashTop = objHash.offset().top;
    
    scrollToTab(objHash);      	
  } 
     
  /**
  * check if element is in viewport
  */
  function isElementInViewport(element) {    
    var elementTop = element.offset().top;
    var elementBottom = elementTop + element.outerHeight();
    
    var viewportTop = jQuery(window).scrollTop();
    var viewportBottom = viewportTop + jQuery(window).height();
    
    var isInViwport = elementBottom > viewportTop && elementTop < viewportBottom;
    
    return(isInViwport);
  } 
    
  /**
  * scrolls to selected tab
  */   
  function scrollToSelectedTab(objTab){    	            
    scrollToTab(objTab);  
  }      
     
  /**
  * check if tab is in viewport and scroll
  */    
  function onTabsClick(){  
    var dataScrollAfterSelected = jQuerytabs.data("scroll-after-selected");
    
    {% if fire_resize_event_on_tab_click == "true" %}
      window.dispatchEvent(new Event('resize'));
    {% endif %}
    
    if(dataScrollAfterSelected == false){

      var objTab = jQuery(this);

      //if in viewport - do nothing
      if(isElementInViewport(objTab) == true)
      return(true);  

      scrollToSelectedTab(objTab);
    }
  }
     
  /**
  * suppooert of elementor tabs
  */
  function onElementorTabClick(){
    var objButton = jQuery(this);
    var dataContentId = objButton.attr("aria-controls");
    
    if(!dataContentId)
    return(true);
    
    var objContent = jQuery("#"+dataContentId);
    
    if(!objContent)
    return(true);  
      
    var objUETabs = objContent.find(".uc_bold_tabs");
    
    if(!objUETabs)
    return(true); 
    
    setTimeout(function(){
      jQuerytabs.responsiveContentTabs("init", "destroy");
      objUETabs.responsiveContentTabs("reinit", tabsOptions);
    },300)
  }   
  
  //set timeout in case other script scrolls the page so this one was last   
  setTimeout(scrollToHashedTab, 400);
     
  //scroll to tab after remote widget triggered click   
  objTabs.on("click", onTabsClick);
     
  //scrolls to head in responsive mode   
  initScrollOption(); 
    
  //reinit tabs after ajax (filters) refresh   
  jQuerytabs.on("uc_ajax_refreshed", function(){
    
    jQuerytabs.responsiveContentTabs("init", "destroy");
    jQuerytabs.responsiveContentTabs("reinit", tabsOptions);
    initScrollOption();
  
  });
     
  //elemtnor tab click
  objElementorTabs.on("click", onElementorTabClick); 
     
  var objRemoteOptions = {
    	class_items:"r-tabs-tab",
    	class_active:"r-tabs-state-active",
    	selector_item_trigger:".r-tabs-anchor"
  };
      
  {{ucfunc("put_remote_parent_js","jQuerytabs","objRemoteOptions")}}  
    	
 }    	
 if (jQuery("#{{uc_id}}").length && !jQuery("#{{uc_id}}").parents('[data-elementor-type="popup"]').length || jQuery("#{{uc_id}}").length && "{{uc_inside_editor}}" == "yes") {{uc_id}}_start();
 jQuery(document).on("elementor/popup/show", (event, id, objPopup) => {
    if (objPopup.$element.has(jQuery("#{{uc_id}}")).length) {{uc_id}}_start();
 });
});