<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_about_us_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'About Us V1', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'about_us_v1',
            [
                'label' => esc_html__( 'About Us V1', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'bold_text',
            [
                'label'       => __( 'Bold Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'features',
            [
                'label'       => __( 'Features', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'top_image',
            [
                'label' => __( 'Top Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'bottom_image',
            [
                'label' => __( 'Bottom Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'image_icon',
            [
				'label' => esc_html__('Select Icon', 'vezaconslt'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
		$this->add_control(
            'image_text',
            [
                'label'       => __( 'Image Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- about-section -->
        <section class="about-section p_relative pt_110">
            <div class="pattern-layer p_absolute l_0" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/shape/shape-1.png'); ?>);"></div>
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                        <div class="content_block_1">
                            <div class="content-box p_relative d_block mr_70 pb_90">
                                <div class="sec-title p_relative d_block mb_40">
                                    <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                </div>
                                <div class="text p_relative d_block mb_30">
                                    <h5 class="fs_18 fw_medium theme-color mb_35"><?php echo wp_kses( $settings['bold_text'], true ); ?></h5>
                                    <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                                </div>
                                
                                <?php $features_list = $settings['features'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); ?>
                                <ul class="list-style-one clearfix p_relative d_block">
                                	<?php foreach($features_list as $features): ?>
									<li class="p_relative d_iblock fs_16 lh_25 fw_sbold black-color mb_15 pull-left"><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <div class="image_block_1">
                            <div class="image-box p_relative d_block pl_70">
                                <figure class="image p_relative d_block image-1 b_radius_10 tran_5"><img src="<?php echo esc_url(wp_get_attachment_url($settings['top_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <figure class="image image-2 p_absolute r_120 b_radius_10 wow slideInRight animated" data-wow-delay="00ms" data-wow-duration="1500ms"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bottom_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <?php if ($settings['image_icon'] and $settings['image_text']){ ?>
                                <div class="text p_absolute t_160 b_radius_10 b_shadow_7 bg-white pt_35 pr_40 pb_35 pl_110">
                                    <div class="icon-box p_absolute l_30 t_30 fs_65 theme-color"><i class="<?php echo wp_kses( $settings['image_icon'], true ); ?>"></i></div>
                                    <h5 class="d_block fs_18"><?php echo wp_kses( $settings['image_text'], true ); ?></h5>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-section end -->
        
        <?php
    }
}
