<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V3 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  3.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_about_us_v3';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  3.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'About Us V3', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  3.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  3.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  3.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'about_us_v3',
            [
                'label' => esc_html__( 'About Us V3', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'image_icon',
            [
				'label' => esc_html__('Select Icon', 'vezaconslt'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
		$this->add_control(
            'image_text',
            [
                'label'       => __( 'Image Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'image_bottom_text',
            [
                'label'       => __( 'Image Bottom Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'Features', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
				'separator' => 'before',
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'author_image',
            [
                'label' => __( 'Author Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'signature',
            [
                'label' => __( 'Signature', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- about-style-three -->
        <section class="about-style-three p_relative sec-pad">
            <div class="pattern-layer p_absolute l_0" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/shape/shape-1.png'); ?>);"></div>
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <div class="image_block_1">
                            <div class="image-box p_relative d_block pb_30">
                                <figure class="image p_relative d_block image-1 b_radius_10 tran_5"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                
                                <?php if ($settings['image_icon'] or $settings['image_text']){ ?>
                                <div class="text p_absolute t_160 b_radius_10 b_shadow_7 bg-white pt_35 pr_40 pb_35 pl_110">
                                    <div class="icon-box p_absolute l_30 t_30 fs_65 theme-color"><i class="<?php echo esc_attr( $settings['image_icon'] ); ?>"></i></div>
                                    <h5 class="d_block fs_18"><?php echo wp_kses( $settings['image_text'], true ); ?></h5>
                                </div>
                                <?php } ?>
                                
                                <?php if ($settings['image_bottom_text']){ ?>
                                <div class="text-two centred p_absolute l_30 b_0 theme-color-bg b_radius_10 pt_30 pr_15 pb_30 pl_15">
                                    <h4 class="fs_20 lh_30 color-white"><?php echo wp_kses( $settings['image_bottom_text'], true ); ?></h4>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                        <div class="content_block_3">
                            <div class="content-box p_relative d_block ml_50">
                                <div class="sec-title p_relative d_block mb_40">
                                    <span class="p_relative d_block fs_14 lh_20 fw_sbold mb_7 theme-color"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                </div>
                                <div class="inner p_relative d_block mb_40">
                                    <div class="row clearfix">
                                        <?php foreach($settings['slides'] as $key => $item): ?>
                                        <div class="col-lg-6 col-md-6 col-sm-12 single-column">
                                            <div class="single-item p_relative d_block">
                                                <div class="icon-box p_relative d_block fs_16 theme-color mb_2"><i class="fas fa-check-circle"></i></div>
                                                <h5 class="d_block fs_18 lh_30 fw_sbold mb_3"><?php echo wp_kses($item['title'], true); ?></h5>
                                                <p><?php echo wp_kses($item['text'], true); ?></p>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="text p_relative d_block mb_50">
                                    <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                                </div>
                                <div class="author-box p_relative d_block pl_100">
                                    <figure class="author-thumb p_absolute l_0 w_75 h_75 b_radius_50"><img src="<?php echo esc_url(wp_get_attachment_url($settings['author_image']['id'])); ?>" alt="<?php esc_html_e('Author Image', 'vezaconslt'); ?>"></figure>
                                    <div class="signature"><img src="<?php echo esc_url(wp_get_attachment_url($settings['signature']['id'])); ?>" alt="<?php esc_html_e('Signature', 'vezaconslt'); ?>"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-style-three end -->
        
        <?php
    }
}
