<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Apply_Immigration_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_apply_immigration_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Apply Immigration V1', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'apply_immigration_v1',
            [
                'label' => esc_html__( 'Apply Immigration V1', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vezaconslt' ),
                    'title'      => esc_html__( 'Title', 'vezaconslt' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vezaconslt' ),
                    'rand'       => esc_html__( 'Random', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vezaconslt' ),
                    'ASC'  => esc_html__( 'ASC', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'vezaconslt'),
                'options' => get_categories_list('country_cat'),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = vezaconslt_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-vezaconslt' );
        $args = array(
            'post_type'      => 'country',
            'posts_per_page' => vezaconslt_set( $settings, 'query_number' ),
            'orderby'        => vezaconslt_set( $settings, 'query_orderby' ),
            'order'          => vezaconslt_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( vezaconslt_set( $settings, 'query_category' ) ) $args['country_cat'] = vezaconslt_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- country-section -->
        <section class="country-section bg-color-1 pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-12 col-sm-12 title-column">
                        <div class="sec-title p_relative d_block mb_40 light mr_60">
                            <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                            <h2 class="p_relative d_block lh_55 fw_exbold color-white"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-12 col-sm-12 inner-column">
                        <div class="inner-content centred">
                            <div class="four-item-carousel owl-carousel owl-theme owl-nav-none">
                                <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                                <div class="single-item p_relative d_block">
                                    <figure class="image-box p_relative d_block b_radius_10"><?php the_post_thumbnail('vezaconslt_270x285'); ?></figure>
                                    <?php $icon_image = get_post_meta( get_the_id(), 'flag', true ); ?>
                                    <div class="flag p_absolute t_40"><img src="<?php echo wp_get_attachment_url($icon_image['id']);?>" alt="<?php esc_attr_e('Flag', 'vezaconslt'); ?>"></div>
                                    <div class="text p_absolute pb_30 l_0 b_0 r_0 z_1">
                                        <h3 class="d_block fs_24 lh_30"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="color-white hov-color"><?php the_title(); ?></a></h3>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- country-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
