<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Coaching_Details extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_coaching_details';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Coaching Details', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'coaching_details',
            [
                'label' => esc_html__( 'Coaching Details', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'features',
            [
                'label'   => esc_html__( 'Features', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
							'name' => 'icon',
							'label' => esc_html__('Select Icon', 'vezaconslt'),
							'type' => Controls_Manager::SELECT2,
							'label_block' => true,
							'options' => get_fontawesome_icons(),
						],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
		
		//Coaching Benifits
		$this->start_controls_section(
            'benifits_tab',
            [
                'label' => esc_html__( 'Coaching Benifits', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'image1',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'title1',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text1',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'features1',
            [
                'label'       => __( 'Features', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Faqs Tabs
		$this->start_controls_section(
            'tabs_tab',
            [
                'label' => esc_html__( 'Faqs Tabs', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'faqs_tab',
            [
                'label'   => esc_html__( 'Faqs', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
		
		//Sidebar
		$this->start_controls_section(
            'sidebar_tab',
            [
                'label' => esc_html__( 'Sidebar', 'vezaconslt' ),
            ]
        );
		$this->add_control(
			'sidebar',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'separate' => 'before',
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => vezaconslt_get_sidebars(),
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- coaching-details -->
        <section class="coaching-details p_relative pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side"> 
                        <div class="coaching-sidebar p_relative d_block">
                            <?php dynamic_sidebar( $settings['sidebar'] ); ?>
                        </div>
                    </div>
                    
                    <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                        <div class="coaching-details-content p_relative d_block">
                            <div class="content-one p_relative d_block mb_55">
                                <figure class="image-box featured-image p_relative d_block b_radius_10 mb_30"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <div class="text">
                                    <h2 class="d_block fs_36 lh_45 mb_25"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                                </div>
                            </div>
                            <div class="content-two clearfix p_relative d_block b_radius_10 mb_60">
                                <?php foreach($settings['features'] as $key => $item) { ?>
                                <div class="single-item p_relative pt_55 pr_30 pb_50 pl_60">
                                    <div class="icon-box p_relative d_iblock fs_65 lh_65 theme-color mb_10"><i class="<?php echo esc_attr($item['icon']); ?>"></i></div>
                                    <h4 class="d_block fs_20 lh_30 fw_bold mb_12"><?php echo wp_kses( $item['title'], true ); ?></h4>
                                    <p><?php echo wp_kses( $item['text'], true ); ?></p>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="content-three p_relative d_block mb_60">
                                <div class="row align-items-center clearfix">
                                    <div class="col-lg-6 col-md-6 col-sm-12 image-column">
                                        <figure class="image-box p_relative d_block b_radius_10"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 text-column">
                                        <div class="text">
                                            <h3 class="d_block fs_24 lh_30 fw_bold mb_35"><?php echo wp_kses( $settings['title1'], true ); ?></h3>
                                            <h4 class="d_block fs_20 lh_34 theme-color mb_35 fw_medium"><?php echo wp_kses( $settings['text1'], true ); ?></h4>
                                            
                                            <?php $features_list = $settings['features1'];
											if(!empty($features_list)){
											$features_list = explode("\n", ($features_list)); ?>
                                            <ul class="list clearfix">
                                            	<?php foreach($features_list as $features): ?>
                                                <li class="p_relative d_block fs_16 fw_medium mb_6 pl_30"><?php echo wp_kses($features, true); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($settings['faqs_tab']){ ?>
                            <div class="content-four">
                                <ul class="accordion-box">
                                	<?php $i=1; foreach($settings['faqs_tab'] as $key => $item) { ?>
                                    <li class="accordion block <?php if($i==1) echo 'active-block'; ?> p_relative d_block mb_20 b_radius_10">
                                        <div class="acc-btn <?php if($i==1) echo 'active'; ?> p_relative d_block tran_5 pt_20 pr_80 pb_20 pl_30">
                                            <div class="icon-outer p_absolute fs_30 t_17 r_30 blue-color tran_5 z_1"></div>
                                            <h5 class="d_block fs_18 lh_30 fw_bold"><?php echo wp_kses( $item['title'], true ); ?></h5>
                                        </div>
                                        <div class="acc-content <?php if($i==1) echo 'current'; ?> p_relative pl_30 pr_40 pb_30 pt_30">
                                            <div class="text">
                                                <p class="fs_16 lh_32 fw_medium"><?php echo wp_kses( $item['text'], true ); ?></p>
                                            </div>
                                        </div>
                                    </li>
                                    <?php $i++; } ?>
                                </ul>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- coaching-details end -->
        
        <?php
    }
}
