<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Exerienced_Agents extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_exerienced_agents';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Exerienced Agents', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'video_tab',
            [
                'label' => esc_html__( 'Video', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'video_image',
            [
                'label' => __( 'Video Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'video_url',
            [
                'label'       => __( 'Video URL', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Exerienced Agents
		$this->start_controls_section(
            'exerienced_agents_tab',
            [
                'label' => esc_html__( 'Exerienced Agents', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'features',
            [
                'label'       => __( 'Features', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'Features', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'vezaconslt'),
                            'type' => Controls_Manager::SELECT2,
							'label_block' => true,
                            'options' => get_fontawesome_icons(),
                        ],
                        [
                            'name' => 'counter_start',
                            'label' => esc_html__('Counter Start', 'vezaconslt'),
                            'type' => Controls_Manager::NUMBER,
                            'default' => 0,
                        ],
                        [
                            'name' => 'counter_stop',
                            'label' => esc_html__('Counter Stop', 'vezaconslt'),
                            'type' => Controls_Manager::NUMBER,
                        ],
						[
                            'name' => 'counter_sign',
                            'label' => esc_html__('Counter Sign', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- chooseus-section -->
        <section class="chooseus-section p_relative pt_120">
            <figure class="image-layer p_absolute r_60"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>" alt="<?php esc_html_e('Background Image', 'vezaconslt'); ?>"></figure>
            <div class="bg-layer bg-color-2 p_absolute l_0 t_0"></div>
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <div class="image-box mr_100 p_relative d_block">
                            <figure class="image clearfix p_relative"><img src="<?php echo esc_url(wp_get_attachment_url($settings['video_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                            
                            <?php if ($settings['video_url']){ ?>
                            <div class="video-btn p_absolute r_0 b_0">
                                <a href="<?php echo esc_url($settings['video_url']); ?>" class="lightbox-image fs_30 color-white theme-color-bg" data-caption=""><i class="fa fa-play"></i></a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                        <div class="content-box">
                            <div class="sec-title p_relative d_block mb_30">
                                <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                            </div>
                            <div class="text p_relative d_block mb_60">
                                <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                            </div>
                            <div class="inner p_relative d_block pl_200 mb_170">
                                <figure class="image-box p_absolute l_0 w_170 h_170 b_radius_50"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <?php $features_list = $settings['features'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); ?>
                                <ul class="list-style-one clearfix p_relative d_block mb_30">
                                	<?php foreach($features_list as $features): ?>
									<li class="p_relative d_block fs_18 lh_25 fw_medium black-color mb_19"><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>
                            </div>
                            <div class="funfact-inner">
                                <div class="row clearfix">
                                    <?php foreach($settings['slides'] as $key => $item) { ?>
                                    <div class="col-lg-6 col-md-6 col-sm-12 counter-block">
                                        <div class="counter-block-one">
                                            <div class="inner-box p_relative d_block">
                                                <div class="icon-box p_relative d_block fs_65 theme-color mb_10"><i class="<?php echo esc_attr($item['icon']); ?>"></i></div>
                                                <div class="count-outer count-box p_relative d_block fs_50 lh_50 fw_bold black-color">
                                                    <span class="count-text" data-speed="1500" data-stop="<?php echo esc_attr($item['counter_stop']); ?>"><?php echo wp_kses($item['counter_start'], $allowed_tags); ?></span><?php if($item['counter_sign']){ ?><span><?php echo wp_kses($item['counter_sign'], $allowed_tags); ?></span><?php } ?>
                                                </div>
                                                <p class="lh_26"><?php echo wp_kses($item['title'], true); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- chooseus-section end -->
        
        <?php
    }
}
