<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Slider_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_slider_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Slider V2', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  2.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'slider_v2',
            [
                'label' => esc_html__( 'Slider V2', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'slides',
            [
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'bg_image',
                            'label' => esc_html__('Background Image', 'vezaconslt'),
                            'type' => Controls_Manager::MEDIA,
                            'default' => ['url' => Utils::get_placeholder_image_src(),],
                        ],
                        [
                            'name' => 'vertical_text',
                            'label' => esc_html__('Vertical Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'subtitle',
                            'label' => esc_html__('Sub Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                        [
                            'name' => 'btn_title',
                            'label' => esc_html__('Button Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link', 'vezaconslt'),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://your-link.com/', 'vezaconslt' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- banner-section -->
        <section class="banner-section style-two p_relative">
            <div class="banner-carousel owl-theme owl-carousel owl-dots-none">
                <?php foreach($settings['slides'] as $key => $item): ?>
                <div class="slide-item p_relative pt_190 pb_190">
                    <div class="image-layer p_absolute" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['bg_image']['id'])); ?>)"></div>
                    <div class="auto-container">
                        <div class="content-box p_relative d_block z_5">
                            <span class="rotate-text"><?php echo wp_kses($item['vertical_text'], true); ?></span>
                            <h3 class="p_relative d_iblock fw_normal fs_24 lh_30 color-white pb_3 mb_10"><?php echo wp_kses($item['subtitle'], true); ?></h3>
                            <h1 class="color-white d_block fs_85 lh_90 mb_45 fw_exbold"><?php echo wp_kses($item['title'], true); ?></h1>
                            
                            <?php if($item['btn_link']['url'] and $item['btn_title']) { ?>
                            <div class="btn-box clearfix">
                                <a href="<?php echo esc_url( $item['btn_link']['url'] ); ?>" class="theme-btn btn-one"><?php echo wp_kses($item['btn_title'], true); ?></a>
                            </div>
                            <?php } ?>
                        </div> 
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </section>
        <!-- banner-section end -->
        
        <?php
    }
}
