<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_about_us_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'About Us V1', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'about_us_v1',
            [
                'label' => esc_html__( 'About Us V1', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'phone_number',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'email_address',
            [
                'label'       => __( 'Email Address', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'address',
            [
                'label'       => __( 'Address', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'social_media',
            [
                'label'   => esc_html__( 'Social Media', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'vezaconslt'),
                            'type' => Controls_Manager::SELECT2,
							'label_block' => true,
                            'options' => get_fontawesome_icons(),
                        ],
						[
                            'name' => 'social_link',
							'label' => __( 'Social Link', 'vezaconslt' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com/', 'vezaconslt' ),
							'show_external' => true,
							'default' => [
								'url' => '',
								'is_external' => true,
								'nofollow' => true,
							],
						]
                    ],
            ]
        );
		$this->add_control(
            'skills',
            [
                'label'   => esc_html__( 'Skills', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'skill_name',
                            'label' => esc_html__('Skill Name', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'skill_value',
                            'label' => esc_html__('Skill Value', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                    ],
            ]
        );
		$this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Contact Form 7', 'vezaconslt'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- team-details -->
        <section class="team-details p_relative pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-12 col-sm-12 image-column">
                        <div class="image-box p_relative d_block mr_20">
                            <div class="image p_relative d_block b_radius_10 mb_25"><?php the_post_thumbnail('vezaconslt_370x470'); ?></div>
                            <ul class="info clearfix">
                                <?php if (get_post_meta( get_the_id(), 'phone_number', true )){ ?>
                                <li class="p_relative d_block mb_2 fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Tel:', 'vezaconslt'); ?></span> <a href="tel:<?php echo esc_attr(phone_number(get_post_meta( get_the_id(), 'phone_number', true ))); ?>" class="hov_color"><?php echo wp_kses(get_post_meta( get_the_id(), 'phone_number', true ), true); ?></a></li>
                                <?php } ?>
                                
                                <?php if (get_post_meta( get_the_id(), 'email_address', true )){ ?>
                                <li class="p_relative d_block mb_2 fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Email:', 'vezaconslt'); ?></span> <a href="mailto:<?php echo sanitize_email(get_post_meta( get_the_id(), 'email_address', true )); ?>" class="hov_color"><?php echo sanitize_email(get_post_meta( get_the_id(), 'email_address', true )); ?></a></li>
                                <?php } ?>
                                
                                <?php if (get_post_meta( get_the_id(), 'address', true )){ ?>
                                <li class="p_relative d_block fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Add:', 'vezaconslt'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'address', true ), true); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-12 col-sm-12 content-column">
                        <div class="content-box p_relative d_block ml_20">
                            <div class="text p_relative d_block mb_60">
                                <h2 class="d_block fs_30 lh_40 fw_bold mb_3"><?php the_title(); ?></h2>
                                <span class="designation p_relative d_block fs_15 lh_26 mb_25"><?php echo get_post_meta( get_the_id(), 'designation', true ); ?></span>
                                <div class="text">
                                    <?php the_content(); ?>
                                </div>
                            </div>
                            
                            <?php $icons = get_post_meta( get_the_id(), 'social_profile', true );
                            if ( ! empty( $icons ) ) : ?>
                            <!-- Social Box -->
                            <div class="social-box p_relative d_block mb_65">
                                <h3 class="fs_22 lh_30 fw_medium mb_12"><?php esc_html_e('Follow Me On:', 'vezaconslt'); ?></h3>
                                <ul class="social-links clearfix">
                                    <?php foreach ( $icons as $h_icon ) :
                                        $header_social_icons = json_decode( urldecode( vezaconslt_set( $h_icon, 'data' ) ) );
                                        if ( vezaconslt_set( $header_social_icons, 'enable' ) == '' ) {
                                            continue;
                                        }
                                        $icon_class = explode( '-', vezaconslt_set( $header_social_icons, 'icon' ) );
                                    ?>
                                    <li class="p_relative d_iblock float_left mr_10"><a href="<?php echo vezaconslt_set( $header_social_icons, 'url' ); ?>" class="d_block fs_14 b_radius_50 centred" style="background-color:<?php echo vezaconslt_set( $header_social_icons, 'background' ); ?>; color: <?php echo vezaconslt_set( $header_social_icons, 'color' ); ?>" target="_blank"><i class="fab <?php echo esc_attr( vezaconslt_set( $header_social_icons, 'icon' ) ); ?>"></i></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                            <?php endif; ?>
                            
                            <div class="skills-box p_relative d_block mb_65">
                                <h3 class="fs_22 lh_30 fw_bold mb_6">Skills:</h3>
                                <div class="progress-inner p_relative d_block mb_40">
                                    <div class="progress-box p_relative d_block mb_20">
                                        <h5 class="d_block fs_18 lh_30 fw_bold blue-color mb_5">Analysis</h5>
                                        <div class="bar">
                                            <div class="bar-inner count-bar" data-percent="93%"></div>
                                            <div class="count-text p_absolute r_0 b_10 fs_14 fw_medium">93%</div>
                                        </div>
                                    </div>
                                    <div class="progress-box p_relative d_block mb_20">
                                        <h5 class="d_block fs_18 lh_30 fw_bold blue-color mb_5">SEO Audit</h5>
                                        <div class="bar">
                                            <div class="bar-inner count-bar" data-percent="69%"></div>
                                            <div class="count-text p_absolute r_0 b_10 fs_14 fw_medium">69%</div>
                                        </div>
                                    </div>
                                    <div class="progress-box p_relative d_block">
                                        <h5 class="d_block fs_18 lh_30 fw_bold blue-color mb_5">Optimization</h5>
                                        <div class="bar">
                                            <div class="bar-inner count-bar" data-percent="90%"></div>
                                            <div class="count-text p_absolute r_0 b_10 fs_14 fw_medium">90%</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-inner">
                                <h3 class="fs_22 lh_30 fw_bold mb_35">Contact Me</h3>
                                <form action="team-details.html" method="post" class="default-form">
                                    <div class="row clearfix">
                                        <div class="col-lg-6 col-md-6 col-sm-12 column">
                                            <div class="form-group p_relative d_block mb_30">
                                                <input type="text" name="name" placeholder="Your name" required="">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 column">
                                            <div class="form-group p_relative d_block mb_30">
                                                <input type="email" name="email" placeholder="Your Email" required="">
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 column">
                                            <div class="form-group p_relative d_block mb_30">
                                                <textarea name="message" placeholder="Your Message"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 column">
                                            <div class="form-group message-btn p_relative d_block mb-0">
                                                <button type="submit" class="theme-btn btn-two"><span>Send Message</span></button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- team-details end -->




<!-- about-section -->
        <section class="about-section p_relative pt_110">
            <div class="pattern-layer p_absolute l_0" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/shape/shape-1.png'); ?>);"></div>
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                        <div class="content_block_1">
                            <div class="content-box p_relative d_block mr_70 pb_90">
                                <div class="sec-title p_relative d_block mb_40">
                                    <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                </div>
                                <div class="text p_relative d_block mb_30">
                                    <h5 class="fs_18 fw_medium theme-color mb_35"><?php echo wp_kses( $settings['bold_text'], true ); ?></h5>
                                    <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                                </div>
                                
                                <?php $features_list = $settings['features'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); ?>
                                <ul class="list-style-one clearfix p_relative d_block">
                                	<?php foreach($features_list as $features): ?>
									<li class="p_relative d_iblock fs_16 lh_25 fw_sbold black-color mb_15 pull-left"><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <div class="image_block_1">
                            <div class="image-box p_relative d_block pl_70">
                                <figure class="image p_relative d_block image-1 b_radius_10 tran_5"><img src="<?php echo esc_url(wp_get_attachment_url($settings['top_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <figure class="image image-2 p_absolute r_120 b_radius_10 wow slideInRight animated" data-wow-delay="00ms" data-wow-duration="1500ms"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bottom_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <?php if ($settings['image_icon'] and $settings['image_text']){ ?>
                                <div class="text p_absolute t_160 b_radius_10 b_shadow_7 bg-white pt_35 pr_40 pb_35 pl_110">
                                    <div class="icon-box p_absolute l_30 t_30 fs_65 theme-color"><i class="<?php echo wp_kses( $settings['image_icon'], true ); ?>"></i></div>
                                    <h5 class="d_block fs_18"><?php echo wp_kses( $settings['image_text'], true ); ?></h5>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-section end -->
        
        <?php
    }
}
