<?php namespace VEZACONSLTPLUGIN\Inc;
use VEZACONSLTPLUGIN\Inc\Abstracts\Taxonomy;

class Taxonomies extends Taxonomy {

	public static function init() {

		$labels = array(
			'name'              => _x( 'Country Category', 'wpvezaconslt' ),
			'singular_name'     => _x( 'Country Category', 'wpvezaconslt' ),
			'search_items'      => __( 'Search Category', 'wpvezaconslt' ),
			'all_items'         => __( 'All Categories', 'wpvezaconslt' ),
			'parent_item'       => __( 'Parent Category', 'wpvezaconslt' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpvezaconslt' ),
			'edit_item'         => __( 'Edit Category', 'wpvezaconslt' ),
			'update_item'       => __( 'Update Category', 'wpvezaconslt' ),
			'add_new_item'      => __( 'Add New Category', 'wpvezaconslt' ),
			'new_item_name'     => __( 'New Category Name', 'wpvezaconslt' ),
			'menu_name'         => __( 'Country Category', 'wpvezaconslt' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'country_cat' ),
		);
		register_taxonomy( 'country_cat', 'country', $args );
		
		//Services Taxonomy Start
		$labels = array(
			'name'              => _x( 'Service Category', 'wpvezaconslt' ),
			'singular_name'     => _x( 'Service Category', 'wpvezaconslt' ),
			'search_items'      => __( 'Search Category', 'wpvezaconslt' ),
			'all_items'         => __( 'All Categories', 'wpvezaconslt' ),
			'parent_item'       => __( 'Parent Category', 'wpvezaconslt' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpvezaconslt' ),
			'edit_item'         => __( 'Edit Category', 'wpvezaconslt' ),
			'update_item'       => __( 'Update Category', 'wpvezaconslt' ),
			'add_new_item'      => __( 'Add New Category', 'wpvezaconslt' ),
			'new_item_name'     => __( 'New Category Name', 'wpvezaconslt' ),
			'menu_name'         => __( 'Service Category', 'wpvezaconslt' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'service_cat' ),
		);
		register_taxonomy( 'service_cat', 'service', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpvezaconslt' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpvezaconslt' ),
			'search_items'      => __( 'Search Category', 'wpvezaconslt' ),
			'all_items'         => __( 'All Categories', 'wpvezaconslt' ),
			'parent_item'       => __( 'Parent Category', 'wpvezaconslt' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpvezaconslt' ),
			'edit_item'         => __( 'Edit Category', 'wpvezaconslt' ),
			'update_item'       => __( 'Update Category', 'wpvezaconslt' ),
			'add_new_item'      => __( 'Add New Category', 'wpvezaconslt' ),
			'new_item_name'     => __( 'New Category Name', 'wpvezaconslt' ),
			'menu_name'         => __( 'Testimonials Category', 'wpvezaconslt' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);
		register_taxonomy( 'testimonials_cat', 'testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpvezaconslt' ),
			'singular_name'     => _x( 'Team Category', 'wpvezaconslt' ),
			'search_items'      => __( 'Search Category', 'wpvezaconslt' ),
			'all_items'         => __( 'All Categories', 'wpvezaconslt' ),
			'parent_item'       => __( 'Parent Category', 'wpvezaconslt' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpvezaconslt' ),
			'edit_item'         => __( 'Edit Category', 'wpvezaconslt' ),
			'update_item'       => __( 'Update Category', 'wpvezaconslt' ),
			'add_new_item'      => __( 'Add New Category', 'wpvezaconslt' ),
			'new_item_name'     => __( 'New Category Name', 'wpvezaconslt' ),
			'menu_name'         => __( 'Team Category', 'wpvezaconslt' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);
		register_taxonomy( 'team_cat', 'team', $args );
		
		//Coaching Taxonomy Start
		$labels = array(
			'name'              => _x( 'Coaching Category', 'wpvezaconslt' ),
			'singular_name'     => _x( 'Coaching Category', 'wpvezaconslt' ),
			'search_items'      => __( 'Search Category', 'wpvezaconslt' ),
			'all_items'         => __( 'All Categories', 'wpvezaconslt' ),
			'parent_item'       => __( 'Parent Category', 'wpvezaconslt' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpvezaconslt' ),
			'edit_item'         => __( 'Edit Category', 'wpvezaconslt' ),
			'update_item'       => __( 'Update Category', 'wpvezaconslt' ),
			'add_new_item'      => __( 'Add New Category', 'wpvezaconslt' ),
			'new_item_name'     => __( 'New Category Name', 'wpvezaconslt' ),
			'menu_name'         => __( 'Coaching Category', 'wpvezaconslt' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'coaching_cat' ),
		);
		register_taxonomy( 'coaching_cat', 'coaching', $args );
	}
	
}
