<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage vezaconslt
 * @author     Template Path <admin@theme-kalia.com>
 * @version    1.0
 */

$allowed_html = wp_kses_allowed_html( 'post' ); ?>

<?php get_header();
$data = \VEZACONSLT\Includes\Classes\Common::instance()->data( '404' )->get();
do_action( 'vezaconslt_banner', $data );
$options = vezaconslt_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
	?>

<!-- error-section -->
<section class="error-section centred p_relative pt_100 pb_120">
    <div class="auto-container">
        <div class="inner-box">
            <h1 class="d_block fs_200 lh_200 fw_bold theme-color"><?php echo wp_kses( $options->get( 'error_404' ), $allowed_html ) ? wp_kses( $options->get( 'error_404' ), $allowed_html ) : esc_html_e( '404', 'vezaconslt' ); ?></h1>
            <h2 class="d_block fs_44 lh_50 fw_bold mb_10"><?php echo wp_kses( $options->get( 'error_text' ), $allowed_html ) ? wp_kses( $options->get( 'error_text' ), $allowed_html ) : esc_html_e( 'Page not found', 'vezaconslt' ); ?></h2>
            <p class="d_block fw_medium mb_30"><?php echo wp_kses( $options->get( 'error_description' ), $allowed_html ) ? wp_kses( $options->get( 'error_description' ), $allowed_html ) : esc_html_e( 'The page you are looking for was moved, removed or never existed.', 'vezaconslt' ); ?></p>
            
            <?php if ( $options->get('back_to_home_btn') ) : ?>
            <a href="<?php echo( home_url( '/' ) ); ?>" class="theme-btn btn-two"><span><?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Go Home', 'vezaconslt' ); ?></span></a>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- error-section end -->

<?php
}
get_footer(); ?>
