<?php require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'vezaconslt_setup_theme' );
add_action( 'after_setup_theme', 'vezaconslt_load_default_hooks' );


function vezaconslt_setup_theme() {

	load_theme_textdomain( 'vezaconslt', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );


	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
    add_image_size( 'vezaconslt_370x245', 370, 245, true ); //Services V1 & V3
    add_image_size( 'vezaconslt_270x285', 270, 285, true ); //Apply Immigration V1
    add_image_size( 'vezaconslt_77x77', 77, 77, true ); //Testimonials
    add_image_size( 'vezaconslt_390x465', 390, 465, true ); //Immigration Training
    add_image_size( 'vezaconslt_370x215', 370, 215, true ); //Recent Blog V1 & V2
    add_image_size( 'vezaconslt_770x410', 770, 410, true ); //Our Blog & Blog Details
    add_image_size( 'vezaconslt_270x195', 270, 195, true ); //Apply Immigration V2 & Country
    add_image_size( 'vezaconslt_370x470', 370, 470, true ); //Our Agents V1 & V2
    add_image_size( 'vezaconslt_370x470', 370, 470, true ); //Our Agents V1 & V2
    add_image_size( 'vezaconslt_370x465', 370, 465, true ); //Coaching
    add_image_size( 'vezaconslt_70x70', 70, 70, true ); //Blog Sidebar
	
	/*---------- Register image sizes ends ----------*/

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'vezaconslt' ),
		'menu_onepage' => esc_html__( 'Menu OnePage', 'vezaconslt' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'vezaconslt_admin_init', 2000000 );
}

/**
 * [vezaconslt_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function vezaconslt_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [vezaconslt_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function vezaconslt_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'vezaconslt' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'vezaconslt' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'vezaconslt' ),
		'before_widget' => '<div id="%1$s" class="single-sidebar sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title' => '<div class="widget-title"><h4>',
		'after_title' => '</h4></div>'
	) );
	register_sidebar(array(
		'name' => esc_html__( 'Blog Listing', 'vezaconslt' ),
		'id' => 'blog-sidebar',
		'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'vezaconslt' ),
		'before_widget'=>'<div id="%1$s" class="single-sidebar sidebar-widget wow fadeInUp animated widget %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<div class="widget-title"><h4>',
		'after_title' => '</h4></div>'
	));
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'vezaconslt'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'vezaconslt'),
		'before_widget'=>'<div class="col-lg-3 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<div class="widget-title"><h4>',
		'after_title' => '</h4></div>'
	));
	if ( class_exists( '\Elementor\Plugin' )){
		register_sidebar(array(
			'name' => esc_html__('Coaching Widget', 'vezaconslt'),
			'id' => 'coaching-sidebar',
			'description' => esc_html__('Widgets in this area will be shown in Coaching Details Area.', 'vezaconslt'),
			'before_widget' => '<div id="%1$s" class="single-coaching-sidebar %2$s">',
			'after_widget' => '</div>',
			'before_title' => '',
			'after_title' => ''
		));
		register_sidebar(array(
			'name' => esc_html__('Services Widget', 'vezaconslt'),
			'id' => 'services-sidebar',
			'description' => esc_html__('Widgets in this area will be shown in Service Details Area.', 'vezaconslt'),
			'before_widget' => '<div id="%1$s" class="single-service-sidebar sidebar-widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-title"><h4>',
			'after_title' => '</h4></div>'
		));
		register_sidebar(array(
			'name' => esc_html__('Country Widget', 'vezaconslt'),
			'id' => 'country-sidebar',
			'description' => esc_html__('Widgets in this area will be shown in Country Details Area.', 'vezaconslt'),
			'before_widget' => '<div id="%1$s" class="single-country-sidebar sidebar-widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-title"><h4>',
			'after_title' => '</h4></div>'
		));
	}
	
	if ( ! is_object( vezaconslt_WSH() ) ) {
		return;
	}

	$sidebars = vezaconslt_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( vezaconslt_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h4>',
			'after_title'   => '</h4></div>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'vezaconslt_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function vezaconslt_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'vezaconslt' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'vezaconslt' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'vezaconslt' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'vezaconslt' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'vezaconslt' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'vezaconslt' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'vezaconslt' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'vezaconslt' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'vezaconslt' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'vezaconslt_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function vezaconslt_enqueue_scripts() {
	//styles
	wp_enqueue_style( 'fontawesome-all', get_template_directory_uri() . '/assets/css/fontawesome-all.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css' );
    wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/css/owl.css' );
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css' );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
    wp_enqueue_style( 'global', get_template_directory_uri() . '/assets/css/global.css' );
    wp_enqueue_style( 'elpath', get_template_directory_uri() . '/assets/css/elpath.css' );
	wp_enqueue_style( 'vezaconslt-main', get_stylesheet_uri() );
	wp_enqueue_style( 'vezaconslt-color', get_template_directory_uri() . '/assets/css/color.css' );
	wp_enqueue_style( 'vezaconslt-rtl', get_template_directory_uri() . '/assets/css/rtl.css' );
	wp_enqueue_style( 'vezaconslt-main-style', get_template_directory_uri() . '/assets/css/style.css' );
	wp_enqueue_style( 'vezaconslt-blog', get_template_directory_uri() . '/assets/css/blog.css' );
	wp_enqueue_style( 'vezaconslt-service', get_template_directory_uri() . '/assets/css/service.css' );
	wp_enqueue_style( 'vezaconslt-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'vezaconslt-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core');
	wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/assets/js/owl.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'fancybox', get_template_directory_uri().'/assets/js/jquery.fancybox.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'scrollbar', get_template_directory_uri().'/assets/js/scrollbar.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'pagenav', get_template_directory_uri().'/assets/js/pagenav.js', array( 'jquery' ), '2.1.2', true );
    wp_enqueue_script( 'vezaconslt-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'vezaconslt_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function vezaconslt_fonts_url() {
	
	$fonts_url = '';

		$font_families['Poppins']   = 'Poppins:ital,wght@0,300,0,400,0,500,0,600,0,700,0,800,0,900,1,300,1,400,1,500,1,600,1,700,1,800,1,900';
		$font_families['Quattrocento+Sans'] = 'Quattrocento Sans:ital,wght@0,400,0,700,1,400,1,700';

		$font_families = apply_filters( 'VEZACONSLT/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function vezaconslt_theme_styles() {
    wp_enqueue_style( 'vezaconslt-theme-fonts', vezaconslt_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'vezaconslt_theme_styles' );
add_action( 'admin_enqueue_scripts', 'vezaconslt_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) vezaconslt_set function

/**
 * [vezaconslt_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'vezaconslt_set' ) ) {
	function vezaconslt_set( $var, $key, $def = '' ) {
		//if( ! $var ) return false;

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) vezaconslt_add_editor_styles function

function vezaconslt_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'vezaconslt_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = vezaconslt_WSH()->option(); 
if( vezaconslt_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}
/*---------- More functions ends ----------*/

add_filter('doing_it_wrong_trigger_error', function () {return false;}, 10, 0);