<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'vezaconslt' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'vezaconslt' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'vezaconslt' ),
				'e' => esc_html__( 'Elementor', 'vezaconslt' ),
			),
			'default' => 'd',
		),

		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'vezaconslt' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		
		//Author Box
		array(
			'id'      => 'single_post_author_box',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Box', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'vezaconslt' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_tag',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tags', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'vezaconslt' ),
			'default' => false,
		),
		
		//Social Share
		array(
			'id'      => 'single_post_share_us',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Social Sharing', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'vezaconslt' ),
			'default' => false,
		),
		array(
			'id'      => 'facebook_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Facebook Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Facebook', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'twitter_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Twitter Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Twitter', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'linkedin_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Linkedin Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Linkedin', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'pinterest_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Pinterest Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Pinterest', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'reddit_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Reddit Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Reddit', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'tumblr_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tumblr Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Tumblr', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'digg_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Digg Post Share', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Digg', 'vezaconslt' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);





