<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage VEZACONSLT
 * @author     Template Path
 * @version    1.0
 */

if ( class_exists( 'Vezaconslt_Resizer' ) ) {
	$img_obj = new Vezaconslt_Resizer();
} else {
	$img_obj = array();
}

$options = vezaconslt_WSH()->option();

$allowed_tags = wp_kses_allowed_html('post');
global $post;
?>
<div <?php post_class(); ?>>

	<div class="news-block-one wow fadeInUp animated" data-wow-delay="00ms" data-wow-duration="1500ms">
        <div class="inner-box p_relative d_block b_radius_10 tran_5">
            <div class="image-box p_relative d_block">
                <figure class="image p_relative d_block">
                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><i class="fas fa-link"></i></a>
                    <?php the_post_thumbnail('vezaconslt_770x410'); ?>
                </figure>
                <span class="post-date p_absolute r_30 b_0 w_120 fs_12 color-white fw_sbold z_1"><?php echo get_the_date(); ?></span>
            </div>
            <div class="lower-content p_relative d_block pt_25 pr_30 pb_30 pl_30">
                <ul class="post-info clearfix p_relative d_block tran_5">
                    <li class="p_relative d_iblock float_left fs_14 fw_medium mr_25"><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>" class="d_iblock hov-color"><?php esc_html_e('By:', 'vezaconslt'); ?> <?php the_author(); ?></a></li>
                    <li class="p_relative d_iblock float_left fs_14 fw_medium"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>" class="d_iblock hov-color"><?php comments_number( 'Comments: 0', 'Comment: 1', 'Comments: %' ); ?></a></li>
                </ul>
                <h2><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="d_iblock black-color hov-color"><?php the_title(); ?></a></h2>
                <?php the_excerpt(); ?>
                <div class="link"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="p_relative d_iblock fs_14 fw_medium theme-color"><?php esc_html_e('Read More', 'vezaconslt'); ?></a></div>
            </div>
        </div>
    </div>
    
</div>