<?php
/**
 * Footer Template  File
 *
 * @package VEZACONSLT
 * @author  Template Path
 * @version 1.0
 */

$options = vezaconslt_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Background
$footer_bg = $options->get( 'footer_background_image_v1' );
$footer_bg = vezaconslt_set( $footer_bg, 'url', VEZACONSLT_URI . 'assets/images/shape/shape-5.png' );

//Logo
$footer_logo = $options->get( 'footer_logo_v1' );
$footer_logo_dimension = $options->get( 'footer_logo_v1_dimension' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<!-- main-footer -->
    <section class="main-footer" id="footer">
    	<?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
        <div class="image-layer p_absolute r_0 b_0" style="background-image: url(<?php echo esc_url($footer_bg); ?>);"></div>
        <?php } ?>
        
		<?php if( $options->get('show_footer_top_v1') ) { ?>
        <div class="footer-top">
            <div class="auto-container">
                <div class="top-inner">
                    <?php if( $options->get('show_footer_email_address_v1') ) { ?>
                    <div class="info-box">
                        <div class="icon-box"><i class="flaticon-message"></i></div>
                        <span><?php echo wp_kses($options->get('footer_email_title_v1'), $allowed_html); ?></span>
                        <h5><a href="mailto:<?php echo sanitize_email($options->get('footer_email_address_v1')); ?>"><?php echo sanitize_email($options->get('footer_email_address_v1')); ?></a></h5>
                    </div>
                    <?php } ?>
                    
                    <?php if( $footer_logo ) { ?>
                    <figure class="footer-logo"><?php echo vezaconslt_footer_logo( $logo_type, $footer_logo, $footer_logo_dimension, $logo_text, $logo_typography ); ?></figure>
                    <?php } ?>
                    
                    <?php if( $options->get('show_footer_phone_number_v1') ) { ?>
                    <div class="info-box">
                        <div class="icon-box"><i class="flaticon-phone-call"></i></div>
                        <span><?php echo wp_kses($options->get('footer_phone_title_v1'), $allowed_html); ?></span>
                        <h5><a href="tel:<?php echo esc_attr(phone_number($options->get('footer_phone_number_v1'))); ?>"><?php echo wp_kses($options->get('footer_phone_number_v1'), $allowed_html); ?></a></h5>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php } ?>
        
        <?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
        <div class="widget-section">
            <div class="auto-container">
                <div class="row clearfix">
                    <?php dynamic_sidebar( 'footer-sidebar' ); ?>
                </div>
            </div>
        </div>
        <?php } ?>
        
        <div class="footer-bottom">
            <div class="copyright centred">
                <p><?php echo wp_kses( $options->get( 'copyright_text', '&copy; Copyright 2021 by <a href="http://fastwpdemo.com/newwp/vezaconslt/">VezaConslt.com</a>' ), true ); ?></p>
            </div>
        </div>
    </section>
    <!-- main-footer end -->
    