<?php
/**
 * Footer Template  File
 *
 * @package VEZACONSLT
 * @author  Template Path
 * @version 1.0
 */

$options = vezaconslt_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$footer_bg = $options->get( 'footer_background_v2' );
$footer_bg = vezaconslt_set( $footer_bg, 'url', VEZACONSLT_URI . 'assets/images/shape/footer-bg.jpg' ); ?>
	
    <!--Start footer area-->  
	<footer class="footer-area">
		<?php if ( is_active_sidebar( 'footer-sidebar-2' ) ) { ?>
		<div class="footer-bg" style="background-image: url(<?php echo esc_url($footer_bg); ?>)"></div>
		<?php } ?>
		
		<?php if( $options->get('show_footer_contact_v2') ): ?>
		<div class="footer-top">
			<div class="footer-top-bg" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/pattern/footer-top-bg.png'); ?>)"></div>
			<div class="container">
				<div class="row">
					<div class="col-xl-12">
						<div class="footer-top-contact-box">
							<ul>
								<?php if( $options->get('show_footer_address_v2') ) { ?>
								<li>
									<div class="icon">
										<span class="icon-pin-2 thm-clr"></span>
									</div>
									<div class="title">
										<h5><?php echo wp_kses($options->get('footer_address_v2'), $allowed_html); ?></h5>
									</div>
								</li>
								<?php } ?>
								
								<?php if( $options->get('show_footer_email_address_v2') ) { ?>
								<li>
									<div class="icon">
										<span class="icon-envelope thm-clr"></span>
									</div>
									<div class="title">
										<h5><?php echo wp_kses($options->get('footer_email_title_v2'), $allowed_html); ?></h5>
										<h5><a href="mailto:<?php echo sanitize_email($options->get('footer_email_address_v2')); ?>"><?php echo sanitize_email($options->get('footer_email_address_v2')); ?></a></h5>
									</div>
								</li>
								<?php } ?>
								
								<?php if( $options->get('show_footer_phone_number_v2') ) { ?>
								<li>
									<div class="icon">
										<span class="icon-phone thm-clr"></span>
									</div>
									<div class="title">
										<h5><?php echo wp_kses($options->get('footer_phone_title_v2'), $allowed_html); ?></h5>
										<h5><a href="tel:<?php echo esc_attr(phone_number($options->get('footer_phone_number_v2'))); ?>"><?php echo wp_kses($options->get('footer_phone_number_v2'), $allowed_html); ?></a></h5>
									</div>
								</li>
								<?php } ?>
							</ul>
						</div>
					</div>
				</div>
			</div>    
		</div>
		<?php endif; ?>
		
		<?php if ( is_active_sidebar( 'footer-sidebar-2' ) ) { ?>
		<div class="footer">
			<div class="container">
				<div class="row">
					<?php dynamic_sidebar( 'footer-sidebar-2' ); ?>
				</div>
			</div>
		</div>
		<?php } ?>

		<div class="footer-bottom">
			<div class="container">
				<div class="outer-box">
					<div class="copyright-text">
						<p><?php echo wp_kses( $options->get( 'copyright_text', '&copy; Copyright  Vezaconslt 2021. All right reserved. <a href="http://fastwpdemo.com/newwp/vezaconslt/">HomLane</a>' ), true ); ?></p>
					</div>
				</div>    
			</div>    
		</div>

	</footer>   
	<!--End footer area-->
	